/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.unsafe;

import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

@SuppressAnimalSniffer
public final class UnsafeAccess {
    public static final Unsafe UNSAFE;
    private static final boolean DISABLED_BY_USER;

    private UnsafeAccess() {
        throw new IllegalStateException("No instances!");
    }

    public static boolean isUnsafeAvailable() {
        return UNSAFE != null && !DISABLED_BY_USER;
    }

    public static int getAndIncrementInt(Object object, long l2) {
        int n2;
        int n3;
        while (!UNSAFE.compareAndSwapInt(object, l2, n3 = UNSAFE.getIntVolatile(object, l2), n2 = n3 + 1)) {
        }
        return n3;
    }

    public static int getAndAddInt(Object object, long l2, int n2) {
        int n3;
        int n4;
        while (!UNSAFE.compareAndSwapInt(object, l2, n4 = UNSAFE.getIntVolatile(object, l2), n3 = n4 + n2)) {
        }
        return n4;
    }

    public static int getAndSetInt(Object object, long l2, int n2) {
        int n3;
        while (!UNSAFE.compareAndSwapInt(object, l2, n3 = UNSAFE.getIntVolatile(object, l2), n2)) {
        }
        return n3;
    }

    public static boolean compareAndSwapInt(Object object, long l2, int n2, int n3) {
        return UNSAFE.compareAndSwapInt(object, l2, n2, n3);
    }

    public static long addressOf(Class<?> annotatedElement, String object) {
        try {
            annotatedElement = annotatedElement.getDeclaredField((String)object);
            return UNSAFE.objectFieldOffset((Field)annotatedElement);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            object = new InternalError();
            ((Throwable)object).initCause(noSuchFieldException);
            throw object;
        }
    }

    static {
        DISABLED_BY_USER = System.getProperty("com.zoyi.rx.unsafe-disable") != null;
        Unsafe unsafe = null;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Throwable throwable) {}
        UNSAFE = unsafe;
    }
}

