/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.unsafe;

import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import com.zoyi.rx.internal.util.unsafe.Pow2;
import com.zoyi.rx.internal.util.unsafe.QueueProgressIndicators;
import com.zoyi.rx.internal.util.unsafe.SpscUnboundedArrayQueueConsumerField;
import com.zoyi.rx.internal.util.unsafe.SpscUnboundedArrayQueueProducerFields;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.lang.reflect.Field;
import java.util.Iterator;

@SuppressAnimalSniffer
public class SpscUnboundedArrayQueue<E>
extends SpscUnboundedArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    static final int MAX_LOOK_AHEAD_STEP;
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long REF_ARRAY_BASE;
    private static final int REF_ELEMENT_SHIFT;
    private static final Object HAS_NEXT;

    public SpscUnboundedArrayQueue(int n2) {
        n2 = Pow2.roundToPowerOfTwo(n2);
        long l2 = n2 - 1;
        Object[] objectArray = new Object[n2 + 1];
        this.producerBuffer = objectArray;
        this.producerMask = l2;
        this.adjustLookAheadStep(n2);
        this.consumerBuffer = objectArray;
        this.consumerMask = l2;
        this.producerLookAhead = l2 - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean offer(E e2) {
        if (e2 == null) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] objectArray = this.producerBuffer;
        long l2 = this.producerIndex;
        long l3 = this.producerMask;
        long l4 = SpscUnboundedArrayQueue.calcWrappedOffset(l2, l3);
        if (l2 < this.producerLookAhead) {
            return this.writeToQueue(objectArray, e2, l2, l4);
        }
        int n2 = this.producerLookAheadStep;
        long l5 = SpscUnboundedArrayQueue.calcWrappedOffset(l2 + (long)n2, l3);
        if (null == SpscUnboundedArrayQueue.lvElement(objectArray, l5)) {
            this.producerLookAhead = l2 + (long)n2 - 1L;
            return this.writeToQueue(objectArray, e2, l2, l4);
        }
        if (null != SpscUnboundedArrayQueue.lvElement(objectArray, SpscUnboundedArrayQueue.calcWrappedOffset(l2 + 1L, l3))) {
            return this.writeToQueue(objectArray, e2, l2, l4);
        }
        this.resize(objectArray, l2, l4, e2, l3);
        return true;
    }

    private boolean writeToQueue(E[] EArray, E e2, long l2, long l3) {
        SpscUnboundedArrayQueue.soElement(EArray, l3, e2);
        this.soProducerIndex(l2 + 1L);
        return true;
    }

    private void resize(E[] EArray, long l2, long l3, E e2, long l4) {
        int n2 = EArray.length;
        Object[] objectArray = new Object[n2];
        this.producerBuffer = objectArray;
        this.producerLookAhead = l2 + l4 - 1L;
        SpscUnboundedArrayQueue.soElement(objectArray, l3, e2);
        this.soNext(EArray, objectArray);
        SpscUnboundedArrayQueue.soElement(EArray, l3, HAS_NEXT);
        this.soProducerIndex(l2 + 1L);
    }

    private void soNext(E[] EArray, E[] EArray2) {
        SpscUnboundedArrayQueue.soElement(EArray, SpscUnboundedArrayQueue.calcDirectOffset(EArray.length - 1), EArray2);
    }

    private E[] lvNext(E[] EArray) {
        return (Object[])SpscUnboundedArrayQueue.lvElement(EArray, SpscUnboundedArrayQueue.calcDirectOffset(EArray.length - 1));
    }

    @Override
    public final E poll() {
        boolean bl;
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = SpscUnboundedArrayQueue.calcWrappedOffset(l2, l3);
        Object object = SpscUnboundedArrayQueue.lvElement(objectArray, l4);
        boolean bl2 = bl = object == HAS_NEXT;
        if (object != null && !bl) {
            SpscUnboundedArrayQueue.soElement(objectArray, l4, null);
            this.soConsumerIndex(l2 + 1L);
            return (E)object;
        }
        if (bl) {
            return (E)this.newBufferPoll(this.lvNext(objectArray), l2, l3);
        }
        return null;
    }

    private E newBufferPoll(E[] EArray, long l2, long l3) {
        this.consumerBuffer = EArray;
        long l4 = SpscUnboundedArrayQueue.calcWrappedOffset(l2, l3);
        Object object = SpscUnboundedArrayQueue.lvElement(EArray, l4);
        if (object == null) {
            return null;
        }
        SpscUnboundedArrayQueue.soElement(EArray, l4, null);
        this.soConsumerIndex(l2 + 1L);
        return (E)object;
    }

    @Override
    public final E peek() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = SpscUnboundedArrayQueue.calcWrappedOffset(l2, l3);
        Object object = SpscUnboundedArrayQueue.lvElement(objectArray, l4);
        if (object == HAS_NEXT) {
            return (E)this.newBufferPeek(this.lvNext(objectArray), l2, l3);
        }
        return (E)object;
    }

    private E newBufferPeek(E[] EArray, long l2, long l3) {
        this.consumerBuffer = EArray;
        long l4 = SpscUnboundedArrayQueue.calcWrappedOffset(l2, l3);
        return (E)SpscUnboundedArrayQueue.lvElement(EArray, l4);
    }

    @Override
    public final int size() {
        long l2;
        long l3;
        long l4 = this.lvConsumerIndex();
        do {
            l3 = l4;
            l2 = this.lvProducerIndex();
        } while (l3 != (l4 = this.lvConsumerIndex()));
        return (int)(l2 - l4);
    }

    private void adjustLookAheadStep(int n2) {
        this.producerLookAheadStep = Math.min(n2 / 4, MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, l2);
    }

    private void soConsumerIndex(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, l2);
    }

    private static long calcWrappedOffset(long l2, long l3) {
        return SpscUnboundedArrayQueue.calcDirectOffset(l2 & l3);
    }

    private static long calcDirectOffset(long l2) {
        return REF_ARRAY_BASE + (l2 << REF_ELEMENT_SHIFT);
    }

    private static void soElement(Object[] objectArray, long l2, Object object) {
        UnsafeAccess.UNSAFE.putOrderedObject(objectArray, l2, object);
    }

    private static <E> Object lvElement(E[] EArray, long l2) {
        return UnsafeAccess.UNSAFE.getObjectVolatile(EArray, l2);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    static {
        Field field;
        MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
        HAS_NEXT = new Object();
        int n2 = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == n2) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == n2) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
        try {
            field = SpscUnboundedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            InternalError internalError = new InternalError();
            internalError.initCause(noSuchFieldException);
            throw internalError;
        }
        try {
            field = SpscUnboundedArrayQueueConsumerField.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            InternalError internalError = new InternalError();
            internalError.initCause(noSuchFieldException);
            throw internalError;
        }
    }
}

