/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.atomic;

import com.zoyi.rx.internal.util.unsafe.Pow2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscUnboundedAtomicArrayQueue<T>
implements Queue<T> {
    static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    final AtomicLong producerIndex;
    int producerLookAheadStep;
    long producerLookAhead;
    int producerMask;
    AtomicReferenceArray<Object> producerBuffer;
    int consumerMask;
    AtomicReferenceArray<Object> consumerBuffer;
    final AtomicLong consumerIndex;
    private static final Object HAS_NEXT = new Object();

    public SpscUnboundedAtomicArrayQueue(int n2) {
        n2 = Pow2.roundToPowerOfTwo(Math.max(8, n2));
        int n3 = n2 - 1;
        this.producerIndex = new AtomicLong();
        this.consumerIndex = new AtomicLong();
        AtomicReferenceArray atomicReferenceArray = new AtomicReferenceArray(n2 + 1);
        this.producerBuffer = atomicReferenceArray;
        this.producerMask = n3;
        this.adjustLookAheadStep(n2);
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = n3;
        this.producerLookAhead = n3 - 1;
        this.soProducerIndex(0L);
    }

    @Override
    public final boolean offer(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        AtomicReferenceArray<Object> atomicReferenceArray = this.producerBuffer;
        long l2 = this.lpProducerIndex();
        int n2 = this.producerMask;
        int n3 = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(l2, n2);
        if (l2 < this.producerLookAhead) {
            return this.writeToQueue(atomicReferenceArray, t2, l2, n3);
        }
        int n4 = this.producerLookAheadStep;
        int n5 = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(l2 + (long)n4, n2);
        if (null == SpscUnboundedAtomicArrayQueue.lvElement(atomicReferenceArray, n5)) {
            this.producerLookAhead = l2 + (long)n4 - 1L;
            return this.writeToQueue(atomicReferenceArray, t2, l2, n3);
        }
        if (null != SpscUnboundedAtomicArrayQueue.lvElement(atomicReferenceArray, SpscUnboundedAtomicArrayQueue.calcWrappedOffset(l2 + 1L, n2))) {
            return this.writeToQueue(atomicReferenceArray, t2, l2, n3);
        }
        this.resize(atomicReferenceArray, l2, n3, t2, n2);
        return true;
    }

    private boolean writeToQueue(AtomicReferenceArray<Object> atomicReferenceArray, T t2, long l2, int n2) {
        this.soProducerIndex(l2 + 1L);
        SpscUnboundedAtomicArrayQueue.soElement(atomicReferenceArray, n2, t2);
        return true;
    }

    private void resize(AtomicReferenceArray<Object> atomicReferenceArray, long l2, int n2, T t2, long l3) {
        int n3 = atomicReferenceArray.length();
        AtomicReferenceArray<Object> atomicReferenceArray2 = new AtomicReferenceArray<Object>(n3);
        this.producerBuffer = atomicReferenceArray2;
        this.producerLookAhead = l2 + l3 - 1L;
        this.soProducerIndex(l2 + 1L);
        SpscUnboundedAtomicArrayQueue.soElement(atomicReferenceArray2, n2, t2);
        this.soNext(atomicReferenceArray, atomicReferenceArray2);
        SpscUnboundedAtomicArrayQueue.soElement(atomicReferenceArray, n2, HAS_NEXT);
    }

    private void soNext(AtomicReferenceArray<Object> atomicReferenceArray, AtomicReferenceArray<Object> atomicReferenceArray2) {
        SpscUnboundedAtomicArrayQueue.soElement(atomicReferenceArray, SpscUnboundedAtomicArrayQueue.calcDirectOffset(atomicReferenceArray.length() - 1), atomicReferenceArray2);
    }

    private AtomicReferenceArray<Object> lvNext(AtomicReferenceArray<Object> atomicReferenceArray) {
        return (AtomicReferenceArray)SpscUnboundedAtomicArrayQueue.lvElement(atomicReferenceArray, SpscUnboundedAtomicArrayQueue.calcDirectOffset(atomicReferenceArray.length() - 1));
    }

    @Override
    public final T poll() {
        boolean bl;
        int n2;
        AtomicReferenceArray<Object> atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n3 = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(l2, n2 = this.consumerMask);
        Object object = SpscUnboundedAtomicArrayQueue.lvElement(atomicReferenceArray, n3);
        boolean bl2 = bl = object == HAS_NEXT;
        if (object != null && !bl) {
            this.soConsumerIndex(l2 + 1L);
            SpscUnboundedAtomicArrayQueue.soElement(atomicReferenceArray, n3, null);
            return (T)object;
        }
        if (bl) {
            return this.newBufferPoll(this.lvNext(atomicReferenceArray), l2, n2);
        }
        return null;
    }

    private T newBufferPoll(AtomicReferenceArray<Object> atomicReferenceArray, long l2, int n2) {
        this.consumerBuffer = atomicReferenceArray;
        Object object = SpscUnboundedAtomicArrayQueue.lvElement(atomicReferenceArray, n2 = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(l2, n2));
        if (object == null) {
            return null;
        }
        this.soConsumerIndex(l2 + 1L);
        SpscUnboundedAtomicArrayQueue.soElement(atomicReferenceArray, n2, null);
        return (T)object;
    }

    @Override
    public final T peek() {
        int n2;
        AtomicReferenceArray<Object> atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n3 = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(l2, n2 = this.consumerMask);
        Object object = SpscUnboundedAtomicArrayQueue.lvElement(atomicReferenceArray, n3);
        if (object == HAS_NEXT) {
            return this.newBufferPeek(this.lvNext(atomicReferenceArray), l2, n2);
        }
        return (T)object;
    }

    @Override
    public final void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    private T newBufferPeek(AtomicReferenceArray<Object> atomicReferenceArray, long l2, int n2) {
        this.consumerBuffer = atomicReferenceArray;
        int n3 = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(l2, n2);
        return (T)SpscUnboundedAtomicArrayQueue.lvElement(atomicReferenceArray, n3);
    }

    @Override
    public final int size() {
        long l2;
        long l3;
        long l4 = this.lvConsumerIndex();
        do {
            l3 = l4;
            l2 = this.lvProducerIndex();
        } while (l3 != (l4 = this.lvConsumerIndex()));
        return (int)(l2 - l4);
    }

    @Override
    public final boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void adjustLookAheadStep(int n2) {
        this.producerLookAheadStep = Math.min(n2 / 4, MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lpProducerIndex() {
        return this.producerIndex.get();
    }

    private long lpConsumerIndex() {
        return this.consumerIndex.get();
    }

    private void soProducerIndex(long l2) {
        this.producerIndex.lazySet(l2);
    }

    private void soConsumerIndex(long l2) {
        this.consumerIndex.lazySet(l2);
    }

    private static int calcWrappedOffset(long l2, int n2) {
        return SpscUnboundedAtomicArrayQueue.calcDirectOffset((int)l2 & n2);
    }

    private static int calcDirectOffset(int n2) {
        return n2;
    }

    private static void soElement(AtomicReferenceArray<Object> atomicReferenceArray, int n2, Object object) {
        atomicReferenceArray.lazySet(n2, object);
    }

    private static <E> Object lvElement(AtomicReferenceArray<Object> atomicReferenceArray, int n2) {
        return atomicReferenceArray.get(n2);
    }

    @Override
    public final Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <E> E[] toArray(E[] EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean add(T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T element() {
        throw new UnsupportedOperationException();
    }
}

