/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.atomic;

import com.zoyi.rx.internal.util.atomic.LinkedQueueNode;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

abstract class BaseLinkedAtomicQueue<E>
extends AbstractQueue<E> {
    private final AtomicReference<LinkedQueueNode<E>> producerNode = new AtomicReference();
    private final AtomicReference<LinkedQueueNode<E>> consumerNode = new AtomicReference();

    protected final LinkedQueueNode<E> lvProducerNode() {
        return this.producerNode.get();
    }

    protected final LinkedQueueNode<E> lpProducerNode() {
        return this.producerNode.get();
    }

    protected final void spProducerNode(LinkedQueueNode<E> linkedQueueNode) {
        this.producerNode.lazySet(linkedQueueNode);
    }

    protected final LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> linkedQueueNode) {
        return this.producerNode.getAndSet(linkedQueueNode);
    }

    protected final LinkedQueueNode<E> lvConsumerNode() {
        return this.consumerNode.get();
    }

    protected final LinkedQueueNode<E> lpConsumerNode() {
        return this.consumerNode.get();
    }

    protected final void spConsumerNode(LinkedQueueNode<E> linkedQueueNode) {
        this.consumerNode.lazySet(linkedQueueNode);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        int n2;
        LinkedQueueNode<E> linkedQueueNode = this.lvConsumerNode();
        LinkedQueueNode<E> linkedQueueNode2 = this.lvProducerNode();
        for (n2 = 0; linkedQueueNode != linkedQueueNode2 && n2 < Integer.MAX_VALUE; ++n2) {
            LinkedQueueNode<E> linkedQueueNode3;
            while ((linkedQueueNode3 = linkedQueueNode.lvNext()) == null) {
            }
            linkedQueueNode = linkedQueueNode3;
        }
        return n2;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }
}

