/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Completable;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Scheduler$Worker;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BufferUntilSubscriber;
import com.zoyi.rx.internal.schedulers.SchedulerWhen$1;
import com.zoyi.rx.internal.schedulers.SchedulerWhen$2;
import com.zoyi.rx.internal.schedulers.SchedulerWhen$3;
import com.zoyi.rx.observers.SerializedObserver;
import com.zoyi.rx.subjects.PublishSubject;
import com.zoyi.rx.subscriptions.Subscriptions;

@Experimental
public class SchedulerWhen
extends Scheduler
implements Subscription {
    private final Scheduler actualScheduler;
    private final Observer<Observable<Completable>> workerObserver;
    private final Subscription subscription;
    private static final Subscription SUBSCRIBED = new SchedulerWhen$3();
    private static final Subscription UNSUBSCRIBED = Subscriptions.unsubscribed();

    public SchedulerWhen(Func1<Observable<Observable<Completable>>, Completable> func1, Scheduler object) {
        this.actualScheduler = object;
        object = PublishSubject.create();
        this.workerObserver = new SerializedObserver<Observable<Completable>>((Observer<Observable<Completable>>)object);
        this.subscription = func1.call(((Observable)object).onBackpressureBuffer()).subscribe();
    }

    @Override
    public void unsubscribe() {
        this.subscription.unsubscribe();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.subscription.isUnsubscribed();
    }

    @Override
    public Scheduler$Worker createWorker() {
        Scheduler$Worker scheduler$Worker = this.actualScheduler.createWorker();
        Observable observable = BufferUntilSubscriber.create();
        SerializedObserver serializedObserver = new SerializedObserver(observable);
        observable = observable.map(new SchedulerWhen$1(this, scheduler$Worker));
        scheduler$Worker = new SchedulerWhen$2(this, scheduler$Worker, serializedObserver);
        this.workerObserver.onNext(observable);
        return scheduler$Worker;
    }

    static /* synthetic */ Subscription access$100() {
        return SUBSCRIBED;
    }

    static /* synthetic */ Subscription access$200() {
        return UNSUBSCRIBED;
    }
}

