/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.internal.schedulers.CachedThreadScheduler;
import com.zoyi.rx.internal.schedulers.CachedThreadScheduler$CachedWorkerPool$1;
import com.zoyi.rx.internal.schedulers.CachedThreadScheduler$CachedWorkerPool$2;
import com.zoyi.rx.internal.schedulers.CachedThreadScheduler$ThreadWorker;
import com.zoyi.rx.internal.schedulers.NewThreadWorker;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class CachedThreadScheduler$CachedWorkerPool {
    private final ThreadFactory threadFactory;
    private final long keepAliveTime;
    private final ConcurrentLinkedQueue<CachedThreadScheduler$ThreadWorker> expiringWorkerQueue;
    private final CompositeSubscription allWorkers;
    private final ScheduledExecutorService evictorService;
    private final Future<?> evictorTask;

    CachedThreadScheduler$CachedWorkerPool(ThreadFactory threadFactory, long l2, TimeUnit timeUnit) {
        this.threadFactory = threadFactory;
        this.keepAliveTime = timeUnit != null ? timeUnit.toNanos(l2) : 0L;
        this.expiringWorkerQueue = new ConcurrentLinkedQueue();
        this.allWorkers = new CompositeSubscription();
        ScheduledExecutorService scheduledExecutorService = null;
        ScheduledFuture<?> scheduledFuture = null;
        if (timeUnit != null) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1, new CachedThreadScheduler$CachedWorkerPool$1(this, threadFactory));
            NewThreadWorker.tryEnableCancelPolicy(scheduledExecutorService);
            scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(new CachedThreadScheduler$CachedWorkerPool$2(this), this.keepAliveTime, this.keepAliveTime, TimeUnit.NANOSECONDS);
        }
        this.evictorService = scheduledExecutorService;
        this.evictorTask = scheduledFuture;
    }

    final CachedThreadScheduler$ThreadWorker get() {
        CachedThreadScheduler$ThreadWorker cachedThreadScheduler$ThreadWorker;
        if (this.allWorkers.isUnsubscribed()) {
            return CachedThreadScheduler.SHUTDOWN_THREADWORKER;
        }
        while (!this.expiringWorkerQueue.isEmpty()) {
            cachedThreadScheduler$ThreadWorker = this.expiringWorkerQueue.poll();
            if (cachedThreadScheduler$ThreadWorker == null) continue;
            return cachedThreadScheduler$ThreadWorker;
        }
        cachedThreadScheduler$ThreadWorker = new CachedThreadScheduler$ThreadWorker(this.threadFactory);
        this.allWorkers.add(cachedThreadScheduler$ThreadWorker);
        return cachedThreadScheduler$ThreadWorker;
    }

    final void release(CachedThreadScheduler$ThreadWorker cachedThreadScheduler$ThreadWorker) {
        cachedThreadScheduler$ThreadWorker.setExpirationTime(this.now() + this.keepAliveTime);
        this.expiringWorkerQueue.offer(cachedThreadScheduler$ThreadWorker);
    }

    final void evictExpiredWorkers() {
        if (!this.expiringWorkerQueue.isEmpty()) {
            long l2 = this.now();
            for (CachedThreadScheduler$ThreadWorker cachedThreadScheduler$ThreadWorker : this.expiringWorkerQueue) {
                if (cachedThreadScheduler$ThreadWorker.getExpirationTime() > l2) break;
                if (!this.expiringWorkerQueue.remove(cachedThreadScheduler$ThreadWorker)) continue;
                this.allWorkers.remove(cachedThreadScheduler$ThreadWorker);
            }
        }
    }

    final long now() {
        return System.nanoTime();
    }

    final void shutdown() {
        try {
            if (this.evictorTask != null) {
                this.evictorTask.cancel(true);
            }
            if (this.evictorService != null) {
                this.evictorService.shutdownNow();
            }
            return;
        }
        finally {
            this.allWorkers.unsubscribe();
        }
    }
}

