/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleProducer<T>
extends AtomicBoolean
implements Producer {
    private static final long serialVersionUID = -3353584923995471404L;
    final Subscriber<? super T> child;
    final T value;

    public SingleProducer(Subscriber<? super T> subscriber, T t2) {
        this.child = subscriber;
        this.value = t2;
    }

    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (l2 == 0L) {
            return;
        }
        if (this.compareAndSet(false, true)) {
            Subscriber<T> subscriber = this.child;
            if (subscriber.isUnsubscribed()) {
                return;
            }
            T t2 = this.value;
            try {
                subscriber.onNext(t2);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Exceptions.throwOrReport(throwable, subscriber, t2);
                return;
            }
            if (subscriber.isUnsubscribed()) {
                return;
            }
            subscriber.onCompleted();
        }
    }
}

