/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.FuncN;
import com.zoyi.rx.internal.operators.OperatorZip$Zip$InnerSubscriber;
import com.zoyi.rx.internal.util.RxRingBuffer;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.atomic.AtomicLong;

final class OperatorZip$Zip<R>
extends AtomicLong {
    private static final long serialVersionUID = 5995274816189928317L;
    final Observer<? super R> child;
    private final FuncN<? extends R> zipFunction;
    private final CompositeSubscription childSubscription = new CompositeSubscription();
    static final int THRESHOLD = (int)((double)RxRingBuffer.SIZE * 0.7);
    int emitted;
    private volatile Object[] subscribers;
    private AtomicLong requested;

    public OperatorZip$Zip(Subscriber<? super R> subscriber, FuncN<? extends R> funcN) {
        this.child = subscriber;
        this.zipFunction = funcN;
        subscriber.add(this.childSubscription);
    }

    public final void start(Observable[] observableArray, AtomicLong atomicLong) {
        int n2;
        Object[] objectArray = new Object[observableArray.length];
        for (n2 = 0; n2 < observableArray.length; ++n2) {
            OperatorZip$Zip$InnerSubscriber operatorZip$Zip$InnerSubscriber = new OperatorZip$Zip$InnerSubscriber(this);
            objectArray[n2] = operatorZip$Zip$InnerSubscriber;
            this.childSubscription.add(operatorZip$Zip$InnerSubscriber);
        }
        this.requested = atomicLong;
        this.subscribers = objectArray;
        for (n2 = 0; n2 < observableArray.length; ++n2) {
            observableArray[n2].unsafeSubscribe((OperatorZip$Zip$InnerSubscriber)objectArray[n2]);
        }
    }

    final void tick() {
        Object[] objectArray = this.subscribers;
        if (this.subscribers == null) {
            return;
        }
        if (this.getAndIncrement() == 0L) {
            int n2 = objectArray.length;
            Observer<R> observer = this.child;
            AtomicLong atomicLong = this.requested;
            while (true) {
                Object object = new Object[n2];
                boolean bl = true;
                for (int i2 = 0; i2 < n2; ++i2) {
                    RxRingBuffer rxRingBuffer = ((OperatorZip$Zip$InnerSubscriber)objectArray[i2]).items;
                    Object object2 = rxRingBuffer.peek();
                    if (object2 == null) {
                        bl = false;
                        continue;
                    }
                    if (rxRingBuffer.isCompleted(object2)) {
                        observer.onCompleted();
                        this.childSubscription.unsubscribe();
                        return;
                    }
                    object[i2] = rxRingBuffer.getValue(object2);
                }
                if (atomicLong.get() > 0L && bl) {
                    int n3;
                    try {
                        observer.onNext(this.zipFunction.call((Object[])object));
                        atomicLong.decrementAndGet();
                        ++this.emitted;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Exceptions.throwOrReport(throwable, observer, object);
                        return;
                    }
                    Object[] objectArray2 = objectArray;
                    int n4 = objectArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        object = objectArray2[n3];
                        object = ((OperatorZip$Zip$InnerSubscriber)object).items;
                        ((RxRingBuffer)object).poll();
                        if (!((RxRingBuffer)object).isCompleted(((RxRingBuffer)object).peek())) continue;
                        observer.onCompleted();
                        this.childSubscription.unsubscribe();
                        return;
                    }
                    if (this.emitted <= THRESHOLD) continue;
                    objectArray2 = objectArray;
                    n4 = objectArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        object = objectArray2[n3];
                        ((OperatorZip$Zip$InnerSubscriber)object).requestMore(this.emitted);
                    }
                    this.emitted = 0;
                    continue;
                }
                if (this.decrementAndGet() <= 0L) break;
            }
        }
    }
}

