/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OperatorReplay$InnerProducer;
import com.zoyi.rx.internal.operators.OperatorReplay$ReplayBuffer;
import com.zoyi.rx.internal.operators.OperatorReplay$ReplaySubscriber$1;
import com.zoyi.rx.internal.util.OpenHashSet;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class OperatorReplay$ReplaySubscriber<T>
extends Subscriber<T>
implements Subscription {
    final OperatorReplay$ReplayBuffer<T> buffer;
    final NotificationLite<T> nl;
    boolean done;
    static final OperatorReplay$InnerProducer[] EMPTY = new OperatorReplay$InnerProducer[0];
    static final OperatorReplay$InnerProducer[] TERMINATED = new OperatorReplay$InnerProducer[0];
    volatile boolean terminated;
    final OpenHashSet<OperatorReplay$InnerProducer<T>> producers;
    OperatorReplay$InnerProducer<T>[] producersCache;
    volatile long producersVersion;
    long producersCacheVersion;
    final AtomicBoolean shouldConnect;
    boolean emitting;
    boolean missed;
    long maxChildRequested;
    long maxUpstreamRequested;
    volatile Producer producer;
    List<OperatorReplay$InnerProducer<T>> coordinationQueue;
    boolean coordinateAll;

    public OperatorReplay$ReplaySubscriber(OperatorReplay$ReplayBuffer<T> operatorReplay$ReplayBuffer) {
        this.buffer = operatorReplay$ReplayBuffer;
        this.nl = NotificationLite.instance();
        this.producers = new OpenHashSet();
        this.producersCache = EMPTY;
        this.shouldConnect = new AtomicBoolean();
        this.request(0L);
    }

    final void init() {
        this.add(Subscriptions.create(new OperatorReplay$ReplaySubscriber$1(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean add(OperatorReplay$InnerProducer<T> operatorReplay$InnerProducer) {
        if (operatorReplay$InnerProducer == null) {
            throw new NullPointerException();
        }
        if (this.terminated) {
            return false;
        }
        OpenHashSet<OperatorReplay$InnerProducer<T>> openHashSet = this.producers;
        synchronized (openHashSet) {
            if (this.terminated) {
                return false;
            }
            this.producers.add(operatorReplay$InnerProducer);
            ++this.producersVersion;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(OperatorReplay$InnerProducer<T> operatorReplay$InnerProducer) {
        if (this.terminated) {
            return;
        }
        OpenHashSet<OperatorReplay$InnerProducer<T>> openHashSet = this.producers;
        synchronized (openHashSet) {
            if (this.terminated) {
                return;
            }
            this.producers.remove(operatorReplay$InnerProducer);
            if (this.producers.isEmpty()) {
                this.producersCache = EMPTY;
            }
            ++this.producersVersion;
            return;
        }
    }

    @Override
    public final void setProducer(Producer producer) {
        Producer producer2 = this.producer;
        if (producer2 != null) {
            throw new IllegalStateException("Only a single producer can be set on a Subscriber.");
        }
        this.producer = producer;
        this.manageRequests(null);
        this.replay();
    }

    @Override
    public final void onNext(T t2) {
        if (!this.done) {
            this.buffer.next(t2);
            this.replay();
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (!this.done) {
            this.done = true;
            try {
                this.buffer.error(throwable);
                this.replay();
                return;
            }
            finally {
                this.unsubscribe();
            }
        }
    }

    @Override
    public final void onCompleted() {
        if (!this.done) {
            this.done = true;
            try {
                this.buffer.complete();
                this.replay();
                return;
            }
            finally {
                this.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void manageRequests(OperatorReplay$InnerProducer<T> operatorReplay$InnerProducerArray) {
        long l2;
        if (this.isUnsubscribed()) {
            return;
        }
        OperatorReplay$ReplaySubscriber operatorReplay$ReplaySubscriber = this;
        synchronized (operatorReplay$ReplaySubscriber) {
            if (this.emitting) {
                if (operatorReplay$InnerProducerArray != null) {
                    List<OperatorReplay$InnerProducer<T>> list = this.coordinationQueue;
                    if (list == null) {
                        list = new ArrayList<OperatorReplay$InnerProducer<T>>();
                        this.coordinationQueue = list;
                    }
                    list.add((OperatorReplay$InnerProducer<T>)operatorReplay$InnerProducerArray);
                } else {
                    this.coordinateAll = true;
                }
                this.missed = true;
                return;
            }
            this.emitting = true;
        }
        long l3 = this.maxChildRequested;
        if (operatorReplay$InnerProducerArray != null) {
            l2 = Math.max(l3, operatorReplay$InnerProducerArray.totalRequested.get());
        } else {
            l2 = l3;
            OperatorReplay$InnerProducer<T>[] operatorReplay$InnerProducerArray2 = operatorReplay$InnerProducerArray = this.copyProducers();
            int n2 = operatorReplay$InnerProducerArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                OperatorReplay$InnerProducer<T> operatorReplay$InnerProducer = operatorReplay$InnerProducerArray2[i2];
                if (operatorReplay$InnerProducer == null) continue;
                l2 = Math.max(l2, operatorReplay$InnerProducer.totalRequested.get());
            }
        }
        this.makeRequest(l2, l3);
        while (!this.isUnsubscribed()) {
            int n3;
            Object object;
            Object object2 = this;
            synchronized (object2) {
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
                object = this.coordinationQueue;
                this.coordinationQueue = null;
                n3 = this.coordinateAll;
                this.coordinateAll = false;
            }
            l2 = l3 = this.maxChildRequested;
            if (object != null) {
                object2 = object.iterator();
                while (object2.hasNext()) {
                    object = (OperatorReplay$InnerProducer)object2.next();
                    l2 = Math.max(l2, object.totalRequested.get());
                }
            }
            if (n3 != 0) {
                object = object2 = this.copyProducers();
                int n4 = ((OperatorReplay$InnerProducer<T>[])object2).length;
                for (n3 = 0; n3 < n4; ++n3) {
                    object2 = object[n3];
                    if (object2 == null) continue;
                    l2 = Math.max(l2, object2.totalRequested.get());
                }
            }
            this.makeRequest(l2, l3);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final OperatorReplay$InnerProducer<T>[] copyProducers() {
        OpenHashSet<OperatorReplay$InnerProducer<T>> openHashSet = this.producers;
        synchronized (openHashSet) {
            OperatorReplay$InnerProducer<T>[] operatorReplay$InnerProducerArray = this.producers.values();
            int n2 = operatorReplay$InnerProducerArray.length;
            OperatorReplay$InnerProducer[] operatorReplay$InnerProducerArray2 = new OperatorReplay$InnerProducer[n2];
            System.arraycopy(operatorReplay$InnerProducerArray, 0, operatorReplay$InnerProducerArray2, 0, n2);
            return operatorReplay$InnerProducerArray2;
        }
    }

    final void makeRequest(long l2, long l3) {
        long l4 = this.maxUpstreamRequested;
        Producer producer = this.producer;
        long l5 = l2 - l3;
        if (l5 != 0L) {
            this.maxChildRequested = l2;
            if (producer != null) {
                if (l4 != 0L) {
                    this.maxUpstreamRequested = 0L;
                    producer.request(l4 + l5);
                    return;
                }
                producer.request(l5);
                return;
            }
            long l6 = l4 + l5;
            if (l6 < 0L) {
                l6 = Long.MAX_VALUE;
            }
            this.maxUpstreamRequested = l6;
            return;
        }
        if (l4 != 0L && producer != null) {
            this.maxUpstreamRequested = 0L;
            producer.request(l4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replay() {
        int n2;
        OperatorReplay$InnerProducer<T>[] operatorReplay$InnerProducerArray;
        Object object;
        OperatorReplay$InnerProducer<T>[] operatorReplay$InnerProducerArray2 = this.producersCache;
        if (this.producersCacheVersion != this.producersVersion) {
            object = this.producers;
            synchronized (object) {
                operatorReplay$InnerProducerArray2 = this.producersCache;
                operatorReplay$InnerProducerArray = this.producers.values();
                n2 = operatorReplay$InnerProducerArray.length;
                if (operatorReplay$InnerProducerArray2.length != n2) {
                    this.producersCache = operatorReplay$InnerProducerArray2 = new OperatorReplay$InnerProducer[n2];
                }
                System.arraycopy(operatorReplay$InnerProducerArray, 0, operatorReplay$InnerProducerArray2, 0, n2);
                this.producersCacheVersion = this.producersVersion;
            }
        }
        object = this.buffer;
        operatorReplay$InnerProducerArray = operatorReplay$InnerProducerArray2;
        n2 = operatorReplay$InnerProducerArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            OperatorReplay$InnerProducer<T> operatorReplay$InnerProducer = operatorReplay$InnerProducerArray[i2];
            if (operatorReplay$InnerProducer == null) continue;
            object.replay(operatorReplay$InnerProducer);
        }
    }
}

