/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func0;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class OperatorMapNotification$MapNotificationSubscriber<T, R>
extends Subscriber<T> {
    final Subscriber<? super R> actual;
    final Func1<? super T, ? extends R> onNext;
    final Func1<? super Throwable, ? extends R> onError;
    final Func0<? extends R> onCompleted;
    final AtomicLong requested;
    final AtomicLong missedRequested;
    final AtomicReference<Producer> producer;
    long produced;
    R value;
    static final long COMPLETED_FLAG = Long.MIN_VALUE;
    static final long REQUESTED_MASK = Long.MAX_VALUE;

    public OperatorMapNotification$MapNotificationSubscriber(Subscriber<? super R> subscriber, Func1<? super T, ? extends R> func1, Func1<? super Throwable, ? extends R> func12, Func0<? extends R> func0) {
        this.actual = subscriber;
        this.onNext = func1;
        this.onError = func12;
        this.onCompleted = func0;
        this.requested = new AtomicLong();
        this.missedRequested = new AtomicLong();
        this.producer = new AtomicReference();
    }

    @Override
    public final void onNext(T t2) {
        try {
            ++this.produced;
            this.actual.onNext(this.onNext.call(t2));
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwOrReport(throwable, this.actual, t2);
            return;
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        this.accountProduced();
        try {
            this.value = this.onError.call(throwable);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Exceptions.throwOrReport(throwable2, this.actual, (Object)throwable);
        }
        this.tryEmit();
    }

    @Override
    public final void onCompleted() {
        this.accountProduced();
        try {
            this.value = this.onCompleted.call();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwOrReport(throwable, this.actual);
        }
        this.tryEmit();
    }

    final void accountProduced() {
        long l2 = this.produced;
        if (l2 != 0L && this.producer.get() != null) {
            BackpressureUtils.produced(this.requested, l2);
        }
    }

    @Override
    public final void setProducer(Producer producer) {
        if (this.producer.compareAndSet(null, producer)) {
            long l2 = this.missedRequested.getAndSet(0L);
            if (l2 != 0L) {
                producer.request(l2);
            }
            return;
        }
        throw new IllegalStateException("Producer already set!");
    }

    final void tryEmit() {
        long l2;
        while (((l2 = this.requested.get()) & Long.MIN_VALUE) == 0L) {
            if (!this.requested.compareAndSet(l2, l2 | Long.MIN_VALUE)) continue;
            if (l2 != 0L || this.producer.get() == null) {
                if (!this.actual.isUnsubscribed()) {
                    this.actual.onNext(this.value);
                }
                if (!this.actual.isUnsubscribed()) {
                    this.actual.onCompleted();
                }
            }
            return;
        }
    }

    final void requestInner(long l2) {
        long l3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
        if (l2 == 0L) {
            return;
        }
        while (true) {
            long l4;
            if (((l4 = this.requested.get()) & Long.MIN_VALUE) != 0L) {
                l3 = l4 & Long.MAX_VALUE;
                long l5 = BackpressureUtils.addCap(l3, l2) | Long.MIN_VALUE;
                if (!this.requested.compareAndSet(l4, l5)) continue;
                if (l3 == 0L) {
                    if (!this.actual.isUnsubscribed()) {
                        this.actual.onNext(this.value);
                    }
                    if (!this.actual.isUnsubscribed()) {
                        this.actual.onCompleted();
                    }
                }
                return;
            }
            l3 = BackpressureUtils.addCap(l4, l2);
            if (this.requested.compareAndSet(l4, l3)) break;
        }
        AtomicReference<Producer> atomicReference = this.producer;
        Producer producer = atomicReference.get();
        if (producer != null) {
            producer.request(l2);
            return;
        }
        BackpressureUtils.getAndAddRequest(this.missedRequested, l2);
        producer = atomicReference.get();
        if (producer != null && (l3 = this.missedRequested.getAndSet(0L)) != 0L) {
            producer.request(l3);
        }
    }
}

