/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OnSubscribeConcatMap$ConcatMapInnerScalarProducer;
import com.zoyi.rx.internal.operators.OnSubscribeConcatMap$ConcatMapInnerSubscriber;
import com.zoyi.rx.internal.producers.ProducerArbiter;
import com.zoyi.rx.internal.util.ExceptionsUtils;
import com.zoyi.rx.internal.util.ScalarSynchronousObservable;
import com.zoyi.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.SerialSubscription;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class OnSubscribeConcatMap$ConcatMapSubscriber<T, R>
extends Subscriber<T> {
    final Subscriber<? super R> actual;
    final Func1<? super T, ? extends Observable<? extends R>> mapper;
    final int delayErrorMode;
    final ProducerArbiter arbiter;
    final Queue<Object> queue;
    final AtomicInteger wip;
    final AtomicReference<Throwable> error;
    final SerialSubscription inner;
    volatile boolean done;
    volatile boolean active;

    public OnSubscribeConcatMap$ConcatMapSubscriber(Subscriber<? super R> abstractQueue, Func1<? super T, ? extends Observable<? extends R>> func1, int n2, int n3) {
        this.actual = abstractQueue;
        this.mapper = func1;
        this.delayErrorMode = n3;
        this.arbiter = new ProducerArbiter();
        this.wip = new AtomicInteger();
        this.error = new AtomicReference();
        abstractQueue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue(n2) : new SpscAtomicArrayQueue<Object>(n2);
        this.queue = abstractQueue;
        this.inner = new SerialSubscription();
        this.request(n2);
    }

    @Override
    public final void onNext(T t2) {
        if (!this.queue.offer(NotificationLite.instance().next(t2))) {
            this.unsubscribe();
            this.onError(new MissingBackpressureException());
            return;
        }
        this.drain();
    }

    @Override
    public final void onError(Throwable throwable) {
        if (ExceptionsUtils.addThrowable(this.error, throwable)) {
            this.done = true;
            if (this.delayErrorMode == 0) {
                throwable = ExceptionsUtils.terminate(this.error);
                if (!ExceptionsUtils.isTerminated(throwable)) {
                    this.actual.onError(throwable);
                }
                this.inner.unsubscribe();
                return;
            }
            this.drain();
            return;
        }
        this.pluginError(throwable);
    }

    @Override
    public final void onCompleted() {
        this.done = true;
        this.drain();
    }

    final void requestMore(long l2) {
        if (l2 > 0L) {
            this.arbiter.request(l2);
            return;
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
    }

    final void innerNext(R r2) {
        this.actual.onNext(r2);
    }

    final void innerError(Throwable throwable, long l2) {
        if (!ExceptionsUtils.addThrowable(this.error, throwable)) {
            this.pluginError(throwable);
            return;
        }
        if (this.delayErrorMode == 0) {
            throwable = ExceptionsUtils.terminate(this.error);
            if (!ExceptionsUtils.isTerminated(throwable)) {
                this.actual.onError(throwable);
            }
            this.unsubscribe();
            return;
        }
        if (l2 != 0L) {
            this.arbiter.produced(l2);
        }
        this.active = false;
        this.drain();
    }

    final void innerCompleted(long l2) {
        if (l2 != 0L) {
            this.arbiter.produced(l2);
        }
        this.active = false;
        this.drain();
    }

    final void pluginError(Throwable throwable) {
        RxJavaHooks.onError(throwable);
    }

    final void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int n2 = this.delayErrorMode;
        while (true) {
            if (this.actual.isUnsubscribed()) {
                return;
            }
            if (!this.active) {
                boolean bl;
                if (n2 == 1 && this.error.get() != null) {
                    Throwable throwable = ExceptionsUtils.terminate(this.error);
                    if (!ExceptionsUtils.isTerminated(throwable)) {
                        this.actual.onError(throwable);
                    }
                    return;
                }
                boolean bl2 = this.done;
                OnSubscribeConcatMap$ConcatMapInnerSubscriber onSubscribeConcatMap$ConcatMapInnerSubscriber = this.queue.poll();
                boolean bl3 = bl = onSubscribeConcatMap$ConcatMapInnerSubscriber == null;
                if (bl2 && bl) {
                    Throwable throwable = ExceptionsUtils.terminate(this.error);
                    if (throwable == null) {
                        this.actual.onCompleted();
                        return;
                    }
                    if (!ExceptionsUtils.isTerminated(throwable)) {
                        this.actual.onError(throwable);
                    }
                    return;
                }
                if (!bl) {
                    Observable<R> observable;
                    try {
                        observable = this.mapper.call(NotificationLite.instance().getValue(onSubscribeConcatMap$ConcatMapInnerSubscriber));
                    }
                    catch (Throwable throwable) {
                        onSubscribeConcatMap$ConcatMapInnerSubscriber = throwable;
                        Exceptions.throwIfFatal(throwable);
                        this.drainError((Throwable)((Object)onSubscribeConcatMap$ConcatMapInnerSubscriber));
                        return;
                    }
                    if (observable == null) {
                        this.drainError(new NullPointerException("The source returned by the mapper was null"));
                        return;
                    }
                    if (observable != Observable.empty()) {
                        if (observable instanceof ScalarSynchronousObservable) {
                            onSubscribeConcatMap$ConcatMapInnerSubscriber = (ScalarSynchronousObservable)observable;
                            this.active = true;
                            this.arbiter.setProducer(new OnSubscribeConcatMap$ConcatMapInnerScalarProducer(((ScalarSynchronousObservable)((Object)onSubscribeConcatMap$ConcatMapInnerSubscriber)).get(), this));
                        } else {
                            onSubscribeConcatMap$ConcatMapInnerSubscriber = new OnSubscribeConcatMap$ConcatMapInnerSubscriber(this);
                            this.inner.set(onSubscribeConcatMap$ConcatMapInnerSubscriber);
                            if (!onSubscribeConcatMap$ConcatMapInnerSubscriber.isUnsubscribed()) {
                                this.active = true;
                                observable.unsafeSubscribe(onSubscribeConcatMap$ConcatMapInnerSubscriber);
                            } else {
                                return;
                            }
                        }
                        this.request(1L);
                    } else {
                        this.request(1L);
                        continue;
                    }
                }
            }
            if (this.wip.decrementAndGet() == 0) break;
        }
    }

    final void drainError(Throwable throwable) {
        this.unsubscribe();
        if (ExceptionsUtils.addThrowable(this.error, throwable)) {
            throwable = ExceptionsUtils.terminate(this.error);
            if (!ExceptionsUtils.isTerminated(throwable)) {
                this.actual.onError(throwable);
            }
            return;
        }
        this.pluginError(throwable);
    }
}

