/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.functions.FuncN;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.OnSubscribeCombineLatest$CombinerSubscriber;
import com.zoyi.rx.internal.util.atomic.SpscLinkedArrayQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class OnSubscribeCombineLatest$LatestCoordinator<T, R>
extends AtomicInteger
implements Producer,
Subscription {
    private static final long serialVersionUID = 8567835998786448817L;
    final Subscriber<? super R> actual;
    final FuncN<? extends R> combiner;
    final OnSubscribeCombineLatest$CombinerSubscriber<T, R>[] subscribers;
    final int bufferSize;
    final Object[] latest;
    final SpscLinkedArrayQueue<Object> queue;
    final boolean delayError;
    volatile boolean cancelled;
    volatile boolean done;
    final AtomicLong requested;
    final AtomicReference<Throwable> error;
    int active;
    int complete;
    static final Object MISSING = new Object();

    public OnSubscribeCombineLatest$LatestCoordinator(Subscriber<? super R> subscriber, FuncN<? extends R> funcN, int n2, int n3, boolean bl) {
        this.actual = subscriber;
        this.combiner = funcN;
        this.bufferSize = n3;
        this.delayError = bl;
        this.latest = new Object[n2];
        Arrays.fill(this.latest, MISSING);
        this.subscribers = new OnSubscribeCombineLatest$CombinerSubscriber[n2];
        this.queue = new SpscLinkedArrayQueue(n3);
        this.requested = new AtomicLong();
        this.error = new AtomicReference();
    }

    public final void subscribe(Observable<? extends T>[] observableArray) {
        int n2;
        OnSubscribeCombineLatest$CombinerSubscriber<T, R>[] onSubscribeCombineLatest$CombinerSubscriberArray = this.subscribers;
        int n3 = this.subscribers.length;
        for (n2 = 0; n2 < n3; ++n2) {
            onSubscribeCombineLatest$CombinerSubscriberArray[n2] = new OnSubscribeCombineLatest$CombinerSubscriber(this, n2);
        }
        this.lazySet(0);
        this.actual.add(this);
        this.actual.setProducer(this);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.cancelled) {
                return;
            }
            observableArray[n2].subscribe(onSubscribeCombineLatest$CombinerSubscriberArray[n2]);
        }
    }

    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= required but it was " + l2);
        }
        if (l2 != 0L) {
            BackpressureUtils.getAndAddRequest(this.requested, l2);
            this.drain();
        }
    }

    @Override
    public final void unsubscribe() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (this.getAndIncrement() == 0) {
                this.cancel(this.queue);
            }
        }
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.cancelled;
    }

    final void cancel(Queue<?> onSubscribeCombineLatest$CombinerSubscriberArray) {
        onSubscribeCombineLatest$CombinerSubscriberArray.clear();
        onSubscribeCombineLatest$CombinerSubscriberArray = this.subscribers;
        int n2 = this.subscribers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            OnSubscribeCombineLatest$CombinerSubscriber<T, R> onSubscribeCombineLatest$CombinerSubscriber = onSubscribeCombineLatest$CombinerSubscriberArray[i2];
            onSubscribeCombineLatest$CombinerSubscriber.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void combine(Object object, int n2) {
        int n3;
        OnSubscribeCombineLatest$CombinerSubscriber<T, R> onSubscribeCombineLatest$CombinerSubscriber = this.subscribers[n2];
        OnSubscribeCombineLatest$LatestCoordinator onSubscribeCombineLatest$LatestCoordinator = this;
        synchronized (onSubscribeCombineLatest$LatestCoordinator) {
            int n4 = this.latest.length;
            Object object2 = this.latest[n2];
            n3 = this.active;
            if (object2 == MISSING) {
                this.active = ++n3;
            }
            int n5 = this.complete;
            if (object == null) {
                this.complete = ++n5;
            } else {
                this.latest[n2] = onSubscribeCombineLatest$CombinerSubscriber.nl.getValue(object);
            }
            n3 = n3 == n4 ? 1 : 0;
            n2 = n5 == n4 || object == null && object2 == MISSING ? 1 : 0;
            if (n2 == 0) {
                if (object != null && n3 != 0) {
                    this.queue.offer(onSubscribeCombineLatest$CombinerSubscriber, this.latest.clone());
                } else if (!(object != null || this.error.get() == null || object2 != MISSING && this.delayError)) {
                    this.done = true;
                }
            } else {
                this.done = true;
            }
        }
        if (n3 == 0 && object != null) {
            onSubscribeCombineLatest$CombinerSubscriber.requestMore(1L);
            return;
        }
        this.drain();
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        SpscLinkedArrayQueue<Object> spscLinkedArrayQueue = this.queue;
        Subscriber<R> subscriber = this.actual;
        boolean bl = this.delayError;
        AtomicLong atomicLong = this.requested;
        int n2 = 1;
        do {
            long l2;
            if (this.checkTerminated(this.done, spscLinkedArrayQueue.isEmpty(), subscriber, spscLinkedArrayQueue, bl)) {
                return;
            }
            long l3 = atomicLong.get();
            for (l2 = 0L; l2 != l3; ++l2) {
                boolean bl2;
                boolean bl3 = this.done;
                OnSubscribeCombineLatest$CombinerSubscriber onSubscribeCombineLatest$CombinerSubscriber = (OnSubscribeCombineLatest$CombinerSubscriber)spscLinkedArrayQueue.peek();
                boolean bl4 = bl2 = onSubscribeCombineLatest$CombinerSubscriber == null;
                if (this.checkTerminated(bl3, bl2, subscriber, spscLinkedArrayQueue, bl)) {
                    return;
                }
                if (bl2) break;
                spscLinkedArrayQueue.poll();
                Object object = (Object[])spscLinkedArrayQueue.poll();
                if (object == null) {
                    this.cancelled = true;
                    this.cancel(spscLinkedArrayQueue);
                    subscriber.onError(new IllegalStateException("Broken queue?! Sender received but not the array."));
                    return;
                }
                try {
                    object = this.combiner.call(object);
                }
                catch (Throwable throwable) {
                    this.cancelled = true;
                    this.cancel(spscLinkedArrayQueue);
                    subscriber.onError(throwable);
                    return;
                }
                subscriber.onNext(object);
                onSubscribeCombineLatest$CombinerSubscriber.requestMore(1L);
            }
            if (l2 == 0L || l3 == Long.MAX_VALUE) continue;
            BackpressureUtils.produced(atomicLong, l2);
        } while ((n2 = this.addAndGet(-n2)) != 0);
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<?> subscriber, Queue<?> queue, boolean bl3) {
        if (this.cancelled) {
            this.cancel(queue);
            return true;
        }
        if (bl) {
            if (bl3) {
                if (bl2) {
                    Throwable throwable = this.error.get();
                    if (throwable != null) {
                        subscriber.onError(throwable);
                    } else {
                        subscriber.onCompleted();
                    }
                    return true;
                }
            } else {
                Throwable throwable = this.error.get();
                if (throwable != null) {
                    this.cancel(queue);
                    subscriber.onError(throwable);
                    return true;
                }
                if (bl2) {
                    subscriber.onCompleted();
                    return true;
                }
            }
        }
        return false;
    }

    final void onError(Throwable throwable) {
        Serializable serializable;
        Throwable throwable2;
        AtomicReference<Throwable> atomicReference = this.error;
        do {
            if ((throwable2 = atomicReference.get()) != null) {
                if (throwable2 instanceof CompositeException) {
                    serializable = (CompositeException)throwable2;
                    serializable = new ArrayList<Throwable>(((CompositeException)serializable).getExceptions());
                    serializable.add((Throwable)throwable);
                    serializable = new CompositeException((Collection<? extends Throwable>)((Object)serializable));
                    continue;
                }
                serializable = new CompositeException(Arrays.asList(throwable2, throwable));
                continue;
            }
            serializable = throwable;
        } while (!atomicReference.compareAndSet(throwable2, (Throwable)serializable));
    }
}

