/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.operators.CompletableOnSubscribeMerge;
import com.zoyi.rx.internal.operators.CompletableOnSubscribeMerge$CompletableMergeSubscriber$1;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableOnSubscribeMerge$CompletableMergeSubscriber
extends Subscriber<Completable> {
    final CompletableSubscriber actual;
    final CompositeSubscription set;
    final boolean delayErrors;
    volatile boolean done;
    final AtomicReference<Queue<Throwable>> errors;
    final AtomicBoolean once;
    final AtomicInteger wip;

    public CompletableOnSubscribeMerge$CompletableMergeSubscriber(CompletableSubscriber completableSubscriber, int n2, boolean bl) {
        this.actual = completableSubscriber;
        this.delayErrors = bl;
        this.set = new CompositeSubscription();
        this.wip = new AtomicInteger(1);
        this.once = new AtomicBoolean();
        this.errors = new AtomicReference();
        if (n2 == Integer.MAX_VALUE) {
            this.request(Long.MAX_VALUE);
            return;
        }
        this.request(n2);
    }

    final Queue<Throwable> getOrCreateErrors() {
        Queue<Throwable> queue = this.errors.get();
        if (queue != null) {
            return queue;
        }
        queue = new ConcurrentLinkedQueue<Throwable>();
        if (this.errors.compareAndSet(null, queue)) {
            return queue;
        }
        return this.errors.get();
    }

    @Override
    public final void onNext(Completable completable) {
        if (this.done) {
            return;
        }
        this.wip.getAndIncrement();
        completable.unsafeSubscribe(new CompletableOnSubscribeMerge$CompletableMergeSubscriber$1(this));
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.done) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.getOrCreateErrors().offer(throwable);
        this.done = true;
        this.terminate();
    }

    @Override
    public final void onCompleted() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.terminate();
    }

    /*
     * Enabled aggressive block sorting
     */
    final void terminate() {
        if (this.wip.decrementAndGet() == 0) {
            Queue<Throwable> queue = this.errors.get();
            if (queue == null || queue.isEmpty()) {
                this.actual.onCompleted();
                return;
            }
            queue = CompletableOnSubscribeMerge.collectErrors(queue);
            if (this.once.compareAndSet(false, true)) {
                this.actual.onError((Throwable)((Object)queue));
                return;
            }
            RxJavaHooks.onError((Throwable)((Object)queue));
            return;
        }
        if (this.delayErrors) return;
        Queue<Throwable> queue = this.errors.get();
        if (queue == null) return;
        if (queue.isEmpty()) return;
        queue = CompletableOnSubscribeMerge.collectErrors(queue);
        if (this.once.compareAndSet(false, true)) {
            this.actual.onError((Throwable)((Object)queue));
            return;
        }
        RxJavaHooks.onError((Throwable)((Object)queue));
    }

    static /* synthetic */ void access$000(CompletableOnSubscribeMerge$CompletableMergeSubscriber completableOnSubscribeMerge$CompletableMergeSubscriber, long l2) {
        completableOnSubscribeMerge$CompletableMergeSubscriber.request(l2);
    }

    static /* synthetic */ void access$100(CompletableOnSubscribeMerge$CompletableMergeSubscriber completableOnSubscribeMerge$CompletableMergeSubscriber, long l2) {
        completableOnSubscribeMerge$CompletableMergeSubscriber.request(l2);
    }
}

