/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.internal.operators.CompletableOnSubscribeConcat$CompletableConcatSubscriber$ConcatInnerSubscriber;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.SerialSubscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class CompletableOnSubscribeConcat$CompletableConcatSubscriber
extends Subscriber<Completable> {
    final CompletableSubscriber actual;
    final SerialSubscription sr;
    final SpscArrayQueue<Completable> queue;
    volatile boolean done;
    final AtomicBoolean once;
    final CompletableOnSubscribeConcat$CompletableConcatSubscriber$ConcatInnerSubscriber inner;
    final AtomicInteger wip;

    public CompletableOnSubscribeConcat$CompletableConcatSubscriber(CompletableSubscriber completableSubscriber, int n2) {
        this.actual = completableSubscriber;
        this.queue = new SpscArrayQueue(n2);
        this.sr = new SerialSubscription();
        this.inner = new CompletableOnSubscribeConcat$CompletableConcatSubscriber$ConcatInnerSubscriber(this);
        this.wip = new AtomicInteger();
        this.once = new AtomicBoolean();
        this.add(this.sr);
        this.request(n2);
    }

    @Override
    public final void onNext(Completable completable) {
        if (!this.queue.offer(completable)) {
            this.onError(new MissingBackpressureException());
            return;
        }
        if (this.wip.getAndIncrement() == 0) {
            this.next();
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.once.compareAndSet(false, true)) {
            this.actual.onError(throwable);
            return;
        }
        RxJavaHooks.onError(throwable);
    }

    @Override
    public final void onCompleted() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.wip.getAndIncrement() == 0) {
            this.next();
        }
    }

    final void innerError(Throwable throwable) {
        this.unsubscribe();
        this.onError(throwable);
    }

    final void innerComplete() {
        if (this.wip.decrementAndGet() != 0) {
            this.next();
        }
        if (!this.done) {
            this.request(1L);
        }
    }

    final void next() {
        boolean bl = this.done;
        Completable completable = this.queue.poll();
        if (completable == null) {
            if (bl) {
                if (this.once.compareAndSet(false, true)) {
                    this.actual.onCompleted();
                }
                return;
            }
            RxJavaHooks.onError(new IllegalStateException("Queue is empty?!"));
            return;
        }
        completable.unsafeSubscribe(this.inner);
    }
}

