/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.util.UtilityFunctions;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class BackpressureUtils {
    static final long COMPLETED_MASK = Long.MIN_VALUE;
    static final long REQUESTED_MASK = Long.MAX_VALUE;

    private BackpressureUtils() {
        throw new IllegalStateException("No instances!");
    }

    @Deprecated
    public static <T> long getAndAddRequest(AtomicLongFieldUpdater<T> atomicLongFieldUpdater, T t2, long l2) {
        long l3;
        long l4;
        while (!atomicLongFieldUpdater.compareAndSet(t2, l4 = atomicLongFieldUpdater.get(t2), l3 = BackpressureUtils.addCap(l4, l2))) {
        }
        return l4;
    }

    public static long getAndAddRequest(AtomicLong atomicLong, long l2) {
        long l3;
        long l4;
        while (!atomicLong.compareAndSet(l4 = atomicLong.get(), l3 = BackpressureUtils.addCap(l4, l2))) {
        }
        return l4;
    }

    public static long multiplyCap(long l2, long l3) {
        long l4 = l2 * l3;
        if ((l2 | l3) >>> 31 != 0L && l3 != 0L && l4 / l3 != l2) {
            l4 = Long.MAX_VALUE;
        }
        return l4;
    }

    public static long addCap(long l2, long l3) {
        long l4 = l2 + l3;
        if (l4 < 0L) {
            l4 = Long.MAX_VALUE;
        }
        return l4;
    }

    public static <T> void postCompleteDone(AtomicLong atomicLong, Queue<T> queue, Subscriber<? super T> subscriber) {
        BackpressureUtils.postCompleteDone(atomicLong, queue, subscriber, UtilityFunctions.identity());
    }

    public static <T> boolean postCompleteRequest(AtomicLong atomicLong, long l2, Queue<T> queue, Subscriber<? super T> subscriber) {
        return BackpressureUtils.postCompleteRequest(atomicLong, l2, queue, subscriber, UtilityFunctions.identity());
    }

    public static <T, R> void postCompleteDone(AtomicLong atomicLong, Queue<T> queue, Subscriber<? super R> subscriber, Func1<? super T, ? extends R> func1) {
        long l2;
        long l3;
        do {
            if (((l3 = atomicLong.get()) & Long.MIN_VALUE) == 0L) continue;
            return;
        } while (!atomicLong.compareAndSet(l3, l2 = l3 | Long.MIN_VALUE));
        if (l3 != 0L) {
            BackpressureUtils.postCompleteDrain(atomicLong, queue, subscriber, func1);
        }
    }

    public static <T, R> boolean postCompleteRequest(AtomicLong atomicLong, long l2, Queue<T> queue, Subscriber<? super R> subscriber, Func1<? super T, ? extends R> func1) {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
        if (l2 == 0L) {
            return (atomicLong.get() & Long.MIN_VALUE) == 0L;
        }
        do {
            l4 = atomicLong.get();
            l3 = l4 & Long.MIN_VALUE;
            long l5 = l4 & Long.MAX_VALUE;
            long l6 = BackpressureUtils.addCap(l5, l2);
        } while (!atomicLong.compareAndSet(l4, l6 |= l3));
        if (l4 == Long.MIN_VALUE) {
            BackpressureUtils.postCompleteDrain(atomicLong, queue, subscriber, func1);
            return false;
        }
        return l3 == 0L;
    }

    static <T, R> void postCompleteDrain(AtomicLong atomicLong, Queue<T> queue, Subscriber<? super R> subscriber, Func1<? super T, ? extends R> func1) {
        long l2 = atomicLong.get();
        if (l2 == Long.MAX_VALUE) {
            while (true) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                T t2 = queue.poll();
                if (t2 == null) {
                    subscriber.onCompleted();
                    return;
                }
                subscriber.onNext(func1.call(t2));
            }
        }
        long l3 = Long.MIN_VALUE;
        while (true) {
            if (l3 != l2) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                T t3 = queue.poll();
                if (t3 == null) {
                    subscriber.onCompleted();
                    return;
                }
                subscriber.onNext(func1.call(t3));
                ++l3;
                continue;
            }
            if (l3 == l2) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                if (queue.isEmpty()) {
                    subscriber.onCompleted();
                    return;
                }
            }
            if ((l2 = atomicLong.get()) != l3) continue;
            l2 = atomicLong.addAndGet(-(l3 & Long.MAX_VALUE));
            if (l2 == Long.MIN_VALUE) {
                return;
            }
            l3 = Long.MIN_VALUE;
        }
    }

    public static long produced(AtomicLong atomicLong, long l2) {
        long l3;
        long l4;
        do {
            if ((l4 = atomicLong.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            l3 = l4 - l2;
            if (l3 >= 0L) continue;
            throw new IllegalStateException("More produced than requested: " + l3);
        } while (!atomicLong.compareAndSet(l4, l3));
        return l3;
    }

    public static boolean validate(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
        return l2 != 0L;
    }
}

