/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.exceptions;

import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.exceptions.CompositeException$CompositeExceptionCausalChain;
import com.zoyi.rx.exceptions.CompositeException$PrintStreamOrWriter;
import com.zoyi.rx.exceptions.CompositeException$WrappedPrintStream;
import com.zoyi.rx.exceptions.CompositeException$WrappedPrintWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;
    private Throwable cause;

    @Deprecated
    public CompositeException(String object, Collection<? extends Throwable> object2) {
        object = new LinkedHashSet();
        ArrayList arrayList = new ArrayList();
        if (object2 != null) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Throwable throwable = (Throwable)object2.next();
                if (throwable instanceof CompositeException) {
                    object.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    object.add(throwable);
                    continue;
                }
                object.add(new NullPointerException());
            }
        } else {
            object.add(new NullPointerException());
        }
        arrayList.addAll(object);
        this.exceptions = Collections.unmodifiableList(arrayList);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    public CompositeException(Collection<? extends Throwable> collection) {
        this(null, collection);
    }

    @Experimental
    public CompositeException(Throwable ... throwableArray) {
        LinkedHashSet<Throwable> linkedHashSet = new LinkedHashSet<Throwable>();
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (throwableArray != null) {
            for (Throwable throwable : throwableArray) {
                if (throwable instanceof CompositeException) {
                    linkedHashSet.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    linkedHashSet.add(throwable);
                    continue;
                }
                linkedHashSet.add(new NullPointerException());
            }
        } else {
            linkedHashSet.add(new NullPointerException());
        }
        arrayList.addAll(linkedHashSet);
        this.exceptions = Collections.unmodifiableList(arrayList);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    public final List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    @Override
    public final synchronized Throwable getCause() {
        if (this.cause == null) {
            CompositeException$CompositeExceptionCausalChain compositeException$CompositeExceptionCausalChain = new CompositeException$CompositeExceptionCausalChain();
            HashSet<Throwable> hashSet = new HashSet<Throwable>();
            Throwable throwable = compositeException$CompositeExceptionCausalChain;
            for (Throwable throwable2 : this.exceptions) {
                if (hashSet.contains(throwable2)) continue;
                hashSet.add(throwable2);
                Object object = this.getListOfCauses(throwable2);
                object = object.iterator();
                while (object.hasNext()) {
                    Throwable throwable3 = (Throwable)object.next();
                    if (hashSet.contains(throwable3)) {
                        throwable2 = new RuntimeException("Duplicate found in causal chain so cropping to prevent loop ...");
                        continue;
                    }
                    hashSet.add(throwable3);
                }
                try {
                    throwable.initCause(throwable2);
                }
                catch (Throwable throwable4) {}
                throwable = this.getRootCause(throwable);
            }
            this.cause = compositeException$CompositeExceptionCausalChain;
        }
        return this.cause;
    }

    @Override
    public final void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public final void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new CompositeException$WrappedPrintStream(printStream));
    }

    @Override
    public final void printStackTrace(PrintWriter printWriter) {
        this.printStackTrace(new CompositeException$WrappedPrintWriter(printWriter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(CompositeException$PrintStreamOrWriter compositeException$PrintStreamOrWriter) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this).append('\n');
        for (StackTraceElement stackTraceElement : this.getStackTrace()) {
            stringBuilder.append("\tat ").append(stackTraceElement).append('\n');
        }
        int n2 = 1;
        for (Throwable throwable : this.exceptions) {
            stringBuilder.append("  ComposedException ").append(n2).append(" :\n");
            this.appendStackTrace(stringBuilder, throwable, "\t");
            ++n2;
        }
        Object object = compositeException$PrintStreamOrWriter.lock();
        synchronized (object) {
            compositeException$PrintStreamOrWriter.println(stringBuilder.toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendStackTrace(StringBuilder stringBuilder, Throwable throwable, String object) {
        while (true) {
            void var3_4;
            stringBuilder.append((String)var3_4).append(throwable).append('\n');
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stringBuilder.append("\t\tat ").append(stackTraceElement).append('\n');
            }
            if (throwable.getCause() == null) break;
            stringBuilder.append("\tCaused by: ");
            String string = "";
            throwable = throwable.getCause();
        }
    }

    private List<Throwable> getListOfCauses(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null || throwable2 == throwable) {
            return arrayList;
        }
        while (true) {
            arrayList.add(throwable2);
            throwable = throwable2.getCause();
            if (throwable == null || throwable == throwable2) {
                return arrayList;
            }
            throwable2 = throwable2.getCause();
        }
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null || throwable2 == throwable) {
            return throwable;
        }
        while ((throwable = throwable2.getCause()) != null && throwable != throwable2) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }
}

