/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okio;

import com.zoyi.retrofit2.okio.SegmentPool;

final class Segment {
    static final int SIZE = 8192;
    static final int SHARE_MINIMUM = 1024;
    final byte[] data;
    int pos;
    int limit;
    boolean shared;
    boolean owner;
    Segment next;
    Segment prev;

    Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    Segment(Segment segment) {
        this(segment.data, segment.pos, segment.limit);
        segment.shared = true;
    }

    Segment(byte[] byArray, int n2, int n3) {
        this.data = byArray;
        this.pos = n2;
        this.limit = n3;
        this.owner = false;
        this.shared = true;
    }

    public final Segment pop() {
        Segment segment = this.next != this ? this.next : null;
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return segment;
    }

    public final Segment push(Segment segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public final Segment split(int n2) {
        Segment segment;
        if (n2 <= 0 || n2 > this.limit - this.pos) {
            throw new IllegalArgumentException();
        }
        if (n2 >= 1024) {
            segment = new Segment(this);
        } else {
            segment = SegmentPool.take();
            System.arraycopy(this.data, this.pos, segment.data, 0, n2);
        }
        segment.limit = segment.pos + n2;
        this.pos += n2;
        this.prev.push(segment);
        return segment;
    }

    public final void compact() {
        if (this.prev == this) {
            throw new IllegalStateException();
        }
        if (!this.prev.owner) {
            return;
        }
        int n2 = this.limit - this.pos;
        int n3 = 8192 - this.prev.limit + (this.prev.shared ? 0 : this.prev.pos);
        if (n2 > n3) {
            return;
        }
        this.writeTo(this.prev, n2);
        this.pop();
        SegmentPool.recycle(this);
    }

    public final void writeTo(Segment segment, int n2) {
        if (!segment.owner) {
            throw new IllegalArgumentException();
        }
        if (segment.limit + n2 > 8192) {
            if (segment.shared) {
                throw new IllegalArgumentException();
            }
            if (segment.limit + n2 - segment.pos > 8192) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(segment.data, segment.pos, segment.data, 0, segment.limit - segment.pos);
            segment.limit -= segment.pos;
            segment.pos = 0;
        }
        System.arraycopy(this.data, this.pos, segment.data, segment.limit, n2);
        segment.limit += n2;
        this.pos += n2;
    }
}

