/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okio;

import com.zoyi.retrofit2.okio.Buffer$1;
import com.zoyi.retrofit2.okio.Buffer$2;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.Options;
import com.zoyi.retrofit2.okio.Segment;
import com.zoyi.retrofit2.okio.SegmentPool;
import com.zoyi.retrofit2.okio.SegmentedByteString;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Source;
import com.zoyi.retrofit2.okio.Timeout;
import com.zoyi.retrofit2.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Buffer
implements BufferedSink,
BufferedSource,
Cloneable {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int REPLACEMENT_CHARACTER = 65533;
    Segment head;
    long size;

    public final long size() {
        return this.size;
    }

    @Override
    public final Buffer buffer() {
        return this;
    }

    @Override
    public final OutputStream outputStream() {
        return new Buffer$1(this);
    }

    @Override
    public final Buffer emitCompleteSegments() {
        return this;
    }

    @Override
    public final BufferedSink emit() {
        return this;
    }

    @Override
    public final boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public final void require(long l2) throws EOFException {
        if (this.size < l2) {
            throw new EOFException();
        }
    }

    @Override
    public final boolean request(long l2) {
        return this.size >= l2;
    }

    @Override
    public final InputStream inputStream() {
        return new Buffer$2(this);
    }

    public final Buffer copyTo(OutputStream outputStream) throws IOException {
        return this.copyTo(outputStream, 0L, this.size);
    }

    public final Buffer copyTo(OutputStream outputStream, long l2, long l3) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, l2, l3);
        if (l3 == 0L) {
            return this;
        }
        Segment segment = this.head;
        while (l2 >= (long)(segment.limit - segment.pos)) {
            l2 -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l3 > 0L) {
            int n2 = (int)((long)segment.pos + l2);
            int n3 = (int)Math.min((long)(segment.limit - n2), l3);
            outputStream.write(segment.data, n2, n3);
            l3 -= (long)n3;
            l2 = 0L;
            segment = segment.next;
        }
        return this;
    }

    public final Buffer copyTo(Buffer buffer, long l2, long l3) {
        if (buffer == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, l2, l3);
        if (l3 == 0L) {
            return this;
        }
        buffer.size += l3;
        Segment segment = this.head;
        while (l2 >= (long)(segment.limit - segment.pos)) {
            l2 -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l3 > 0L) {
            Segment segment2 = new Segment(segment);
            segment2.pos = (int)((long)segment2.pos + l2);
            segment2.limit = Math.min(segment2.pos + (int)l3, segment2.limit);
            if (buffer.head == null) {
                segment2.next = segment2.prev = segment2;
                buffer.head = segment2.prev;
            } else {
                buffer.head.prev.push(segment2);
            }
            l3 -= (long)(segment2.limit - segment2.pos);
            l2 = 0L;
            segment = segment.next;
        }
        return this;
    }

    public final Buffer writeTo(OutputStream outputStream) throws IOException {
        return this.writeTo(outputStream, this.size);
    }

    public final Buffer writeTo(OutputStream outputStream, long l2) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, 0L, l2);
        Segment segment = this.head;
        while (l2 > 0L) {
            int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
            outputStream.write(segment.data, segment.pos, n2);
            segment.pos += n2;
            this.size -= (long)n2;
            l2 -= (long)n2;
            if (segment.pos != segment.limit) continue;
            Segment segment2 = segment;
            this.head = segment = segment2.pop();
            SegmentPool.recycle(segment2);
        }
        return this;
    }

    public final Buffer readFrom(InputStream inputStream) throws IOException {
        this.readFrom(inputStream, Long.MAX_VALUE, true);
        return this;
    }

    public final Buffer readFrom(InputStream inputStream, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        this.readFrom(inputStream, l2, false);
        return this;
    }

    private void readFrom(InputStream inputStream, long l2, boolean bl) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        while (l2 > 0L || bl) {
            Segment segment = this.writableSegment(1);
            int n2 = (int)Math.min(l2, (long)(8192 - segment.limit));
            if ((n2 = inputStream.read(segment.data, segment.limit, n2)) == -1) {
                if (bl) {
                    return;
                }
                throw new EOFException();
            }
            segment.limit += n2;
            this.size += (long)n2;
            l2 -= (long)n2;
        }
    }

    public final long completeSegmentByteCount() {
        long l2 = this.size;
        if (l2 == 0L) {
            return 0L;
        }
        Segment segment = this.head.prev;
        if (segment.limit < 8192 && segment.owner) {
            l2 -= (long)(segment.limit - segment.pos);
        }
        return l2;
    }

    @Override
    public final byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Segment segment = this.head;
        int n2 = segment.pos;
        int n3 = segment.limit;
        byte[] byArray = segment.data;
        byte by = segment.data[n2++];
        --this.size;
        if (n2 == n3) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return by;
    }

    public final byte getByte(long l2) {
        Util.checkOffsetAndCount(this.size, l2, 1L);
        Segment segment = this.head;
        int n2;
        while (l2 >= (long)(n2 = segment.limit - segment.pos)) {
            l2 -= (long)n2;
            segment = segment.next;
        }
        return segment.data[segment.pos + (int)l2];
    }

    @Override
    public final short readShort() {
        if (this.size < 2L) {
            throw new IllegalStateException("size < 2: " + this.size);
        }
        Segment segment = this.head;
        int n2 = segment.limit;
        int n3 = segment.pos;
        if (n2 - n3 < 2) {
            int n4 = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)n4;
        }
        byte[] byArray = segment.data;
        int n5 = (segment.data[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        this.size -= 2L;
        if (n3 == n2) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n3;
        }
        return (short)n5;
    }

    @Override
    public final int readInt() {
        if (this.size < 4L) {
            throw new IllegalStateException("size < 4: " + this.size);
        }
        Segment segment = this.head;
        int n2 = segment.limit;
        int n3 = segment.pos;
        if (n2 - n3 < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] byArray = segment.data;
        int n4 = (segment.data[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        this.size -= 4L;
        if (n3 == n2) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n3;
        }
        return n4;
    }

    @Override
    public final long readLong() {
        if (this.size < 8L) {
            throw new IllegalStateException("size < 8: " + this.size);
        }
        Segment segment = this.head;
        int n2 = segment.limit;
        int n3 = segment.pos;
        if (n2 - n3 < 8) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        byte[] byArray = segment.data;
        long l2 = ((long)segment.data[n3++] & 0xFFL) << 56 | ((long)byArray[n3++] & 0xFFL) << 48 | ((long)byArray[n3++] & 0xFFL) << 40 | ((long)byArray[n3++] & 0xFFL) << 32 | ((long)byArray[n3++] & 0xFFL) << 24 | ((long)byArray[n3++] & 0xFFL) << 16 | ((long)byArray[n3++] & 0xFFL) << 8 | (long)byArray[n3++] & 0xFFL;
        this.size -= 8L;
        if (n3 == n2) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n3;
        }
        return l2;
    }

    @Override
    public final short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public final int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public final long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public final long readDecimalLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long l2 = 0L;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l3 = -7L;
        do {
            Segment segment = this.head;
            byte[] byArray = segment.data;
            int n3 = segment.pos;
            int n4 = segment.limit;
            while (n3 < n4) {
                byte by = byArray[n3];
                if (by >= 48 && by <= 57) {
                    int n5 = 48 - by;
                    if (l2 < -922337203685477580L || l2 == -922337203685477580L && (long)n5 < l3) {
                        Buffer buffer = new Buffer().writeDecimalLong(l2).writeByte(by);
                        if (!bl) {
                            buffer.readByte();
                        }
                        throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                    }
                    l2 *= 10L;
                    l2 += (long)n5;
                } else if (by == 45 && n2 == 0) {
                    bl = true;
                    --l3;
                } else {
                    if (n2 == 0) {
                        throw new NumberFormatException("Expected leading [0-9] or '-' character but was 0x" + Integer.toHexString(by));
                    }
                    bl2 = true;
                    break;
                }
                ++n3;
                ++n2;
            }
            if (n3 == n4) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n3;
        } while (!bl2 && this.head != null);
        this.size -= (long)n2;
        if (bl) {
            return l2;
        }
        return -l2;
    }

    @Override
    public final long readHexadecimalUnsignedLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long l2 = 0L;
        int n2 = 0;
        boolean bl = false;
        do {
            Segment segment = this.head;
            byte[] byArray = segment.data;
            int n3 = segment.pos;
            int n4 = segment.limit;
            while (n3 < n4) {
                int n5;
                byte by = byArray[n3];
                if (by >= 48 && by <= 57) {
                    n5 = by - 48;
                } else if (by >= 97 && by <= 102) {
                    n5 = by - 97 + 10;
                } else if (by >= 65 && by <= 70) {
                    n5 = by - 65 + 10;
                } else {
                    if (n2 == 0) {
                        throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + Integer.toHexString(by));
                    }
                    bl = true;
                    break;
                }
                if ((l2 & 0xF000000000000000L) != 0L) {
                    Buffer buffer = new Buffer().writeHexadecimalUnsignedLong(l2).writeByte(by);
                    throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                }
                l2 <<= 4;
                l2 |= (long)n5;
                ++n3;
                ++n2;
            }
            if (n3 == n4) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n3;
        } while (!bl && this.head != null);
        this.size -= (long)n2;
        return l2;
    }

    @Override
    public final ByteString readByteString() {
        return new ByteString(this.readByteArray());
    }

    @Override
    public final ByteString readByteString(long l2) throws EOFException {
        return new ByteString(this.readByteArray(l2));
    }

    @Override
    public final int select(Options byteStringArray) {
        Segment segment = this.head;
        if (segment == null) {
            return byteStringArray.indexOf(ByteString.EMPTY);
        }
        byteStringArray = byteStringArray.byteStrings;
        int n2 = byteStringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = byteStringArray[i2];
            if (this.size < (long)byteString.size() || !this.rangeEquals(segment, segment.pos, byteString, 0, byteString.size())) continue;
            try {
                this.skip(byteString.size());
                return i2;
            }
            catch (EOFException eOFException) {
                throw new AssertionError((Object)eOFException);
            }
        }
        return -1;
    }

    final int selectPrefix(Options byteStringArray) {
        Segment segment = this.head;
        byteStringArray = byteStringArray.byteStrings;
        int n2 = byteStringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = byteStringArray[i2];
            int n3 = (int)Math.min(this.size, (long)byteString.size());
            if (n3 != 0 && !this.rangeEquals(segment, segment.pos, byteString, 0, n3)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public final void readFully(Buffer buffer, long l2) throws EOFException {
        if (this.size < l2) {
            buffer.write(this, this.size);
            throw new EOFException();
        }
        buffer.write(this, l2);
    }

    @Override
    public final long readAll(Sink sink) throws IOException {
        long l2 = this.size;
        if (l2 > 0L) {
            sink.write(this, l2);
        }
        return l2;
    }

    @Override
    public final String readUtf8() {
        try {
            return this.readString(this.size, Util.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final String readUtf8(long l2) throws EOFException {
        return this.readString(l2, Util.UTF_8);
    }

    @Override
    public final String readString(Charset charset) {
        try {
            return this.readString(this.size, charset);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final String readString(long l2, Charset object) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        if (object == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l2);
        }
        if (l2 == 0L) {
            return "";
        }
        Segment segment = this.head;
        if ((long)segment.pos + l2 > (long)segment.limit) {
            return new String(this.readByteArray(l2), (Charset)object);
        }
        object = new String(segment.data, segment.pos, (int)l2, (Charset)object);
        segment.pos = (int)((long)segment.pos + l2);
        this.size -= l2;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return object;
    }

    @Override
    public final String readUtf8Line() throws EOFException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            if (this.size != 0L) {
                return this.readUtf8(this.size);
            }
            return null;
        }
        return this.readUtf8Line(l2);
    }

    @Override
    public final String readUtf8LineStrict() throws EOFException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            Buffer buffer = new Buffer();
            this.copyTo(buffer, 0L, Math.min(32L, this.size));
            throw new EOFException("\\n not found: size=" + this.size() + " content=" + buffer.readByteString().hex() + "\u2026");
        }
        return this.readUtf8Line(l2);
    }

    final String readUtf8Line(long l2) throws EOFException {
        if (l2 > 0L && this.getByte(l2 - 1L) == 13) {
            String string = this.readUtf8(l2 - 1L);
            this.skip(2L);
            return string;
        }
        String string = this.readUtf8(l2);
        this.skip(1L);
        return string;
    }

    @Override
    public final int readUtf8CodePoint() throws EOFException {
        int n2;
        int n3;
        int n4;
        if (this.size == 0L) {
            throw new EOFException();
        }
        int n5 = this.getByte(0L);
        if ((n5 & 0x80) == 0) {
            n4 = n5 & 0x7F;
            n3 = 1;
            n2 = 0;
        } else if ((n5 & 0xE0) == 192) {
            n4 = n5 & 0x1F;
            n3 = 2;
            n2 = 128;
        } else if ((n5 & 0xF0) == 224) {
            n4 = n5 & 0xF;
            n3 = 3;
            n2 = 2048;
        } else if ((n5 & 0xF8) == 240) {
            n4 = n5 & 7;
            n3 = 4;
            n2 = 65536;
        } else {
            this.skip(1L);
            return 65533;
        }
        if (this.size < (long)n3) {
            throw new EOFException("size < " + n3 + ": " + this.size + " (to read code point prefixed 0x" + Integer.toHexString(n5) + ")");
        }
        for (n5 = 1; n5 < n3; ++n5) {
            byte by = this.getByte(n5);
            if ((by & 0xC0) == 128) {
                n4 <<= 6;
                n4 |= by & 0x3F;
                continue;
            }
            this.skip(n5);
            return 65533;
        }
        this.skip(n3);
        if (n4 > 0x10FFFF) {
            return 65533;
        }
        if (n4 >= 55296 && n4 <= 57343) {
            return 65533;
        }
        if (n4 < n2) {
            return 65533;
        }
        return n4;
    }

    @Override
    public final byte[] readByteArray() {
        try {
            return this.readByteArray(this.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final byte[] readByteArray(long l2) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l2);
        }
        byte[] byArray = new byte[(int)l2];
        this.readFully(byArray);
        return byArray;
    }

    @Override
    public final int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray) throws EOFException {
        int n2;
        for (int i2 = 0; i2 < byArray.length; i2 += n2) {
            n2 = this.read(byArray, i2, byArray.length - i2);
            if (n2 != -1) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) {
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        n3 = Math.min(n3, segment.limit - segment.pos);
        System.arraycopy(segment.data, segment.pos, byArray, n2, n3);
        segment.pos += n3;
        this.size -= (long)n3;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n3;
    }

    public final void clear() {
        try {
            this.skip(this.size);
            return;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final void skip(long l2) throws EOFException {
        while (l2 > 0L) {
            if (this.head == null) {
                throw new EOFException();
            }
            int n2 = (int)Math.min(l2, (long)(this.head.limit - this.head.pos));
            this.size -= (long)n2;
            l2 -= (long)n2;
            this.head.pos += n2;
            if (this.head.pos != this.head.limit) continue;
            Segment segment = this.head;
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @Override
    public final Buffer write(ByteString byteString) {
        if (byteString == null) {
            throw new IllegalArgumentException("byteString == null");
        }
        byteString.write(this);
        return this;
    }

    @Override
    public final Buffer writeUtf8(String string) {
        return this.writeUtf8(string, 0, string.length());
    }

    @Override
    public final Buffer writeUtf8(String string, int n2, int n3) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n2 < 0) {
            throw new IllegalAccessError("beginIndex < 0: " + n2);
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n3 + " < " + n2);
        }
        if (n3 > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n3 + " > " + string.length());
        }
        while (n2 < n3) {
            char c2;
            int n4 = string.charAt(n2);
            if (n4 < 128) {
                Segment segment = this.writableSegment(1);
                byte[] byArray = segment.data;
                int n5 = segment.limit - n2;
                int n6 = Math.min(n3, 8192 - n5);
                byArray[n5 + n2++] = (byte)n4;
                while (n2 < n6 && (n4 = string.charAt(n2)) < 128) {
                    byArray[n5 + n2++] = (byte)n4;
                }
                n4 = n2 + n5 - segment.limit;
                segment.limit += n4;
                this.size += (long)n4;
                continue;
            }
            if (n4 < 2048) {
                this.writeByte(n4 >> 6 | 0xC0);
                this.writeByte(n4 & 0x3F | 0x80);
                ++n2;
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                this.writeByte(n4 >> 12 | 0xE0);
                this.writeByte(n4 >> 6 & 0x3F | 0x80);
                this.writeByte(n4 & 0x3F | 0x80);
                ++n2;
                continue;
            }
            char c3 = c2 = n2 + 1 < n3 ? string.charAt(n2 + 1) : (char)'\u0000';
            if (n4 > 56319 || c2 < '\udc00' || c2 > '\udfff') {
                this.writeByte(63);
                ++n2;
                continue;
            }
            int n7 = 65536 + ((n4 & 0xFFFF27FF) << 10 | c2 & 0xFFFF23FF);
            this.writeByte(n7 >> 18 | 0xF0);
            this.writeByte(n7 >> 12 & 0x3F | 0x80);
            this.writeByte(n7 >> 6 & 0x3F | 0x80);
            this.writeByte(n7 & 0x3F | 0x80);
            n2 += 2;
        }
        return this;
    }

    @Override
    public final Buffer writeUtf8CodePoint(int n2) {
        if (n2 < 128) {
            this.writeByte(n2);
        } else if (n2 < 2048) {
            this.writeByte(n2 >> 6 | 0xC0);
            this.writeByte(n2 & 0x3F | 0x80);
        } else if (n2 < 65536) {
            if (n2 >= 55296 && n2 <= 57343) {
                throw new IllegalArgumentException("Unexpected code point: " + Integer.toHexString(n2));
            }
            this.writeByte(n2 >> 12 | 0xE0);
            this.writeByte(n2 >> 6 & 0x3F | 0x80);
            this.writeByte(n2 & 0x3F | 0x80);
        } else if (n2 <= 0x10FFFF) {
            this.writeByte(n2 >> 18 | 0xF0);
            this.writeByte(n2 >> 12 & 0x3F | 0x80);
            this.writeByte(n2 >> 6 & 0x3F | 0x80);
            this.writeByte(n2 & 0x3F | 0x80);
        } else {
            throw new IllegalArgumentException("Unexpected code point: " + Integer.toHexString(n2));
        }
        return this;
    }

    @Override
    public final Buffer writeString(String string, Charset charset) {
        return this.writeString(string, 0, string.length(), charset);
    }

    @Override
    public final Buffer writeString(String object, int n2, int n3, Charset charset) {
        if (object == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n2 < 0) {
            throw new IllegalAccessError("beginIndex < 0: " + n2);
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n3 + " < " + n2);
        }
        if (n3 > ((String)object).length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n3 + " > " + ((String)object).length());
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (charset.equals(Util.UTF_8)) {
            return this.writeUtf8((String)object);
        }
        object = ((String)object).substring(n2, n3).getBytes(charset);
        return this.write((byte[])object, 0, ((Object)object).length);
    }

    @Override
    public final Buffer write(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public final Buffer write(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        int n4 = n2 + n3;
        while (n2 < n4) {
            Segment segment = this.writableSegment(1);
            int n5 = Math.min(n4 - n2, 8192 - segment.limit);
            System.arraycopy(byArray, n2, segment.data, segment.limit, n5);
            n2 += n5;
            segment.limit += n5;
        }
        this.size += (long)n3;
        return this;
    }

    @Override
    public final long writeAll(Source source) throws IOException {
        long l2;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long l3 = 0L;
        while ((l2 = source.read(this, 8192L)) != -1L) {
            l3 += l2;
        }
        return l3;
    }

    @Override
    public final BufferedSink write(Source source, long l2) throws IOException {
        while (l2 > 0L) {
            long l3 = source.read(this, l2);
            if (l3 == -1L) {
                throw new EOFException();
            }
            l2 -= l3;
        }
        return this;
    }

    @Override
    public final Buffer writeByte(int n2) {
        Segment segment = this.writableSegment(1);
        segment.data[segment.limit++] = (byte)n2;
        ++this.size;
        return this;
    }

    @Override
    public final Buffer writeShort(int n2) {
        Segment segment = this.writableSegment(2);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        segment.limit = n3;
        this.size += 2L;
        return this;
    }

    @Override
    public final Buffer writeShortLe(int n2) {
        return this.writeShort(Util.reverseBytesShort((short)n2));
    }

    @Override
    public final Buffer writeInt(int n2) {
        Segment segment = this.writableSegment(4);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        segment.limit = n3;
        this.size += 4L;
        return this;
    }

    @Override
    public final Buffer writeIntLe(int n2) {
        return this.writeInt(Util.reverseBytesInt(n2));
    }

    @Override
    public final Buffer writeLong(long l2) {
        Segment segment = this.writableSegment(8);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(l2 >>> 56 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 48 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 40 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 32 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 24 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 16 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 8 & 0xFFL);
        byArray[n2++] = (byte)(l2 & 0xFFL);
        segment.limit = n2;
        this.size += 8L;
        return this;
    }

    @Override
    public final Buffer writeLongLe(long l2) {
        return this.writeLong(Util.reverseBytesLong(l2));
    }

    @Override
    public final Buffer writeDecimalLong(long l2) {
        int n2;
        if (l2 == 0L) {
            return this.writeByte(48);
        }
        boolean bl = false;
        if (l2 < 0L) {
            if ((l2 = -l2) < 0L) {
                return this.writeUtf8("-9223372036854775808");
            }
            bl = true;
        }
        int n3 = l2 < 100000000L ? (l2 < 10000L ? (l2 < 100L ? (l2 < 10L ? 1 : 2) : (l2 < 1000L ? 3 : 4)) : (l2 < 1000000L ? (l2 < 100000L ? 5 : 6) : (l2 < 10000000L ? 7 : 8))) : (l2 < 1000000000000L ? (l2 < 10000000000L ? (l2 < 1000000000L ? 9 : 10) : (l2 < 100000000000L ? 11 : 12)) : (l2 < 1000000000000000L ? (l2 < 10000000000000L ? 13 : (l2 < 100000000000000L ? 14 : 15)) : (l2 < 100000000000000000L ? (l2 < 10000000000000000L ? 16 : 17) : (n2 = l2 < 1000000000000000000L ? 18 : 19))));
        if (bl) {
            ++n2;
        }
        Segment segment = this.writableSegment(n2);
        byte[] byArray = segment.data;
        int n4 = segment.limit + n2;
        while (l2 != 0L) {
            int n5 = (int)(l2 % 10L);
            byArray[--n4] = DIGITS[n5];
            l2 /= 10L;
        }
        if (bl) {
            byArray[--n4] = 45;
        }
        segment.limit += n2;
        this.size += (long)n2;
        return this;
    }

    @Override
    public final Buffer writeHexadecimalUnsignedLong(long l2) {
        if (l2 == 0L) {
            return this.writeByte(48);
        }
        int n2 = Long.numberOfTrailingZeros(Long.highestOneBit(l2)) / 4 + 1;
        Segment segment = this.writableSegment(n2);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        for (int i2 = segment.limit + n2 - 1; i2 >= n3; --i2) {
            byArray[i2] = DIGITS[(int)(l2 & 0xFL)];
            l2 >>>= 4;
        }
        segment.limit += n2;
        this.size += (long)n2;
        return this;
    }

    final Segment writableSegment(int n2) {
        if (n2 <= 0 || n2 > 8192) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.next = this.head.prev = (this.head = SegmentPool.take());
            return this.head.prev;
        }
        Segment segment = this.head.prev;
        if (segment.limit + n2 > 8192 || !segment.owner) {
            segment = segment.push(SegmentPool.take());
        }
        return segment;
    }

    @Override
    public final void write(Buffer buffer, long l2) {
        if (buffer == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (buffer == this) {
            throw new IllegalArgumentException("source == this");
        }
        Util.checkOffsetAndCount(buffer.size, 0L, l2);
        while (l2 > 0L) {
            Segment segment;
            if (l2 < (long)(buffer.head.limit - buffer.head.pos)) {
                segment = this.head != null ? this.head.prev : null;
                if (segment != null && segment.owner && l2 + (long)segment.limit - (long)(segment.shared ? 0 : segment.pos) <= 8192L) {
                    buffer.head.writeTo(segment, (int)l2);
                    buffer.size -= l2;
                    this.size += l2;
                    return;
                }
                buffer.head = buffer.head.split((int)l2);
            }
            segment = buffer.head;
            long l3 = segment.limit - segment.pos;
            buffer.head = segment.pop();
            if (this.head == null) {
                this.head.next = this.head.prev = (this.head = segment);
            } else {
                Segment segment2 = this.head.prev;
                segment2 = segment2.push(segment);
                segment2.compact();
            }
            buffer.size -= l3;
            this.size += l3;
            l2 -= l3;
        }
    }

    @Override
    public final long read(Buffer buffer, long l2) {
        if (buffer == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        if (this.size == 0L) {
            return -1L;
        }
        if (l2 > this.size) {
            l2 = this.size;
        }
        buffer.write(this, l2);
        return l2;
    }

    @Override
    public final long indexOf(byte by) {
        return this.indexOf(by, 0L);
    }

    @Override
    public final long indexOf(byte by, long l2) {
        long l3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - l2 < l2) {
            for (l3 = this.size; l3 > l2; l3 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l4;
            l3 = 0L;
            while ((l4 = l3 + (long)(segment.limit - segment.pos)) < l2) {
                segment = segment.next;
                l3 = l4;
            }
        }
        while (l3 < this.size) {
            byte[] byArray = segment.data;
            int n2 = segment.limit;
            for (int i2 = (int)((long)segment.pos + l2 - l3); i2 < n2; ++i2) {
                if (byArray[i2] != by) continue;
                return (long)(i2 - segment.pos) + l3;
            }
            l2 = l3 += (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        return -1L;
    }

    @Override
    public final long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public final long indexOf(ByteString byteString, long l2) throws IOException {
        long l3;
        if (byteString.size() == 0) {
            throw new IllegalArgumentException("bytes is empty");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - l2 < l2) {
            for (l3 = this.size; l3 > l2; l3 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l4;
            l3 = 0L;
            while ((l4 = l3 + (long)(segment.limit - segment.pos)) < l2) {
                segment = segment.next;
                l3 = l4;
            }
        }
        byte by = byteString.getByte(0);
        int n2 = byteString.size();
        long l5 = this.size - (long)n2 + 1L;
        while (l3 < l5) {
            byte[] byArray = segment.data;
            int n3 = (int)Math.min((long)segment.limit, (long)segment.pos + l5 - l3);
            for (int i2 = (int)((long)segment.pos + l2 - l3); i2 < n3; ++i2) {
                if (byArray[i2] != by || !this.rangeEquals(segment, i2 + 1, byteString, 1, n2)) continue;
                return (long)(i2 - segment.pos) + l3;
            }
            l2 = l3 += (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        return -1L;
    }

    @Override
    public final long indexOfElement(ByteString byteString) {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public final long indexOfElement(ByteString object, long l2) {
        long l3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - l2 < l2) {
            for (l3 = this.size; l3 > l2; l3 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l4;
            l3 = 0L;
            while ((l4 = l3 + (long)(segment.limit - segment.pos)) < l2) {
                segment = segment.next;
                l3 = l4;
            }
        }
        if (((ByteString)object).size() == 2) {
            byte by = ((ByteString)object).getByte(0);
            byte by2 = ((ByteString)object).getByte(1);
            while (l3 < this.size) {
                object = segment.data;
                int n2 = segment.limit;
                for (int i2 = (int)((long)segment.pos + l2 - l3); i2 < n2; ++i2) {
                    Object object2 = object[i2];
                    if (object2 != by && object2 != by2) continue;
                    return (long)(i2 - segment.pos) + l3;
                }
                l2 = l3 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        } else {
            byte[] byArray = ((ByteString)object).internalArray();
            while (l3 < this.size) {
                byte[] byArray2 = segment.data;
                int n3 = segment.limit;
                for (int i3 = (int)((long)segment.pos + l2 - l3); i3 < n3; ++i3) {
                    byte by = byArray2[i3];
                    byte[] byArray3 = byArray;
                    int n4 = byArray.length;
                    for (int i4 = 0; i4 < n4; ++i4) {
                        byte by3 = byArray3[i4];
                        if (by != by3) continue;
                        return (long)(i3 - segment.pos) + l3;
                    }
                }
                l2 = l3 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        }
        return -1L;
    }

    final boolean rangeEquals(long l2, ByteString byteString) {
        int n2 = byteString.size();
        if (this.size - l2 < (long)n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.getByte(l2 + (long)i2) == byteString.getByte(i2)) continue;
            return false;
        }
        return true;
    }

    private boolean rangeEquals(Segment segment, int n2, ByteString byteString, int n3, int n4) {
        int n5 = segment.limit;
        byte[] byArray = segment.data;
        while (n3 < n4) {
            if (n2 == n5) {
                segment = segment.next;
                byArray = segment.data;
                n2 = segment.pos;
                n5 = segment.limit;
            }
            if (byArray[n2] != byteString.getByte(n3)) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void close() {
    }

    @Override
    public final Timeout timeout() {
        return Timeout.NONE;
    }

    final List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.head.limit - this.head.pos);
        Segment segment = this.head.next;
        while (segment != this.head) {
            arrayList.add(segment.limit - segment.pos);
            segment = segment.next;
        }
        return arrayList;
    }

    public final ByteString md5() {
        return this.digest("MD5");
    }

    public final ByteString sha1() {
        return this.digest("SHA-1");
    }

    public final ByteString sha256() {
        return this.digest("SHA-256");
    }

    private ByteString digest(String object) {
        try {
            object = MessageDigest.getInstance((String)object);
            ((MessageDigest)object).update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
            Segment segment = this.head.next;
            while (segment != this.head) {
                ((MessageDigest)object).update(segment.data, segment.pos, segment.limit - segment.pos);
                segment = segment.next;
            }
            return ByteString.of(((MessageDigest)object).digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public final boolean equals(Object object) {
        long l2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        object = (Buffer)object;
        if (this.size != ((Buffer)object).size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Segment segment = this.head;
        object = ((Buffer)object).head;
        int n2 = segment.pos;
        int n3 = ((Segment)object).pos;
        for (long i2 = 0L; i2 < this.size; i2 += l2) {
            l2 = Math.min(segment.limit - n2, ((Segment)object).limit - n3);
            int n4 = 0;
            while ((long)n4 < l2) {
                if (segment.data[n2++] != ((Segment)object).data[n3++]) {
                    return false;
                }
                ++n4;
            }
            if (n2 == segment.limit) {
                segment = segment.next;
                n2 = segment.pos;
            }
            if (n3 != ((Segment)object).limit) continue;
            object = ((Segment)object).next;
            n3 = ((Segment)object).pos;
        }
        return true;
    }

    public final int hashCode() {
        Segment segment = this.head;
        if (segment == null) {
            return 0;
        }
        int n2 = 1;
        do {
            int n3 = segment.limit;
            for (int i2 = segment.pos; i2 < n3; ++i2) {
                n2 = n2 * 31 + segment.data[i2];
            }
        } while ((segment = segment.next) != this.head);
        return n2;
    }

    public final String toString() {
        return this.snapshot().toString();
    }

    public final Buffer clone() {
        Buffer buffer = new Buffer();
        if (this.size == 0L) {
            return buffer;
        }
        buffer.head.next = buffer.head.prev = (buffer.head = new Segment(this.head));
        Segment segment = this.head.next;
        while (segment != this.head) {
            buffer.head.prev.push(new Segment(segment));
            segment = segment.next;
        }
        buffer.size = this.size;
        return buffer;
    }

    public final ByteString snapshot() {
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + this.size);
        }
        return this.snapshot((int)this.size);
    }

    public final ByteString snapshot(int n2) {
        if (n2 == 0) {
            return ByteString.EMPTY;
        }
        return new SegmentedByteString(this, n2);
    }
}

