/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.io;

import com.zoyi.retrofit2.okhttp3.Address;
import com.zoyi.retrofit2.okhttp3.CertificatePinner;
import com.zoyi.retrofit2.okhttp3.Connection;
import com.zoyi.retrofit2.okhttp3.ConnectionSpec;
import com.zoyi.retrofit2.okhttp3.Handshake;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Request$Builder;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.Route;
import com.zoyi.retrofit2.okhttp3.internal.ConnectionSpecSelector;
import com.zoyi.retrofit2.okhttp3.internal.Platform;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.Version;
import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$Builder;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$Listener;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedStream;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream;
import com.zoyi.retrofit2.okhttp3.internal.http.OkHeaders;
import com.zoyi.retrofit2.okhttp3.internal.http.RouteException;
import com.zoyi.retrofit2.okhttp3.internal.http.StreamAllocation;
import com.zoyi.retrofit2.okhttp3.internal.tls.OkHostnameVerifier;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.Okio;
import com.zoyi.retrofit2.okio.Source;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class RealConnection
extends FramedConnection$Listener
implements Connection {
    private final Route route;
    private Socket rawSocket;
    public Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    public volatile FramedConnection framedConnection;
    public int successCount;
    public BufferedSource source;
    public BufferedSink sink;
    public int allocationLimit;
    public final List<Reference<StreamAllocation>> allocations = new ArrayList<Reference<StreamAllocation>>();
    public boolean noNewStreams;
    public long idleAtNanos = Long.MAX_VALUE;

    public RealConnection(Route route) {
        this.route = route;
    }

    public final void connect(int n2, int n3, int n4, List<ConnectionSpec> list, boolean bl) throws RouteException {
        if (this.protocol != null) {
            throw new IllegalStateException("already connected");
        }
        RouteException routeException = null;
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(list);
        if (this.route.address().sslSocketFactory() == null && !list.contains(ConnectionSpec.CLEARTEXT)) {
            throw new RouteException(new UnknownServiceException("CLEARTEXT communication not supported: " + list));
        }
        while (this.protocol == null) {
            try {
                if (this.route.requiresTunnel()) {
                    this.buildTunneledConnection(n2, n3, n4, connectionSpecSelector);
                    continue;
                }
                this.buildConnection(n2, n3, n4, connectionSpecSelector);
            }
            catch (IOException iOException) {
                Util.closeQuietly(this.socket);
                Util.closeQuietly(this.rawSocket);
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                if (routeException == null) {
                    routeException = new RouteException(iOException);
                } else {
                    routeException.addConnectException(iOException);
                }
                if (bl && connectionSpecSelector.connectionFailed(iOException)) continue;
                throw routeException;
            }
        }
    }

    private void buildTunneledConnection(int n2, int n3, int n4, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        int n5 = 0;
        while (true) {
            if (++n5 > 21) {
                throw new ProtocolException("Too many tunnel connections attempted: " + 21);
            }
            this.connectSocket(n2, n3, n4, connectionSpecSelector);
            request = this.createTunnel(n3, n4, request, httpUrl);
            if (request == null) break;
            Util.closeQuietly(this.rawSocket);
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
        }
        this.establishProtocol(n3, n4, connectionSpecSelector);
    }

    private void buildConnection(int n2, int n3, int n4, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        this.connectSocket(n2, n3, n4, connectionSpecSelector);
        this.establishProtocol(n3, n4, connectionSpecSelector);
    }

    private void connectSocket(int n2, int n3, int n4, ConnectionSpecSelector object) throws IOException {
        Proxy proxy = this.route.proxy();
        object = this.route.address();
        this.rawSocket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? ((Address)object).socketFactory().createSocket() : new Socket(proxy);
        this.rawSocket.setSoTimeout(n3);
        try {
            Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), n2);
        }
        catch (ConnectException connectException) {
            throw new ConnectException("Failed to connect to " + this.route.socketAddress());
        }
        this.source = Okio.buffer(Okio.source(this.rawSocket));
        this.sink = Okio.buffer(Okio.sink(this.rawSocket));
    }

    private void establishProtocol(int n2, int n3, ConnectionSpecSelector connectionSpecSelector) throws IOException {
        if (this.route.address().sslSocketFactory() != null) {
            this.connectTls(n2, n3, connectionSpecSelector);
        } else {
            this.protocol = Protocol.HTTP_1_1;
            this.socket = this.rawSocket;
        }
        if (this.protocol == Protocol.SPDY_3 || this.protocol == Protocol.HTTP_2) {
            this.socket.setSoTimeout(0);
            FramedConnection framedConnection = new FramedConnection$Builder(true).socket(this.socket, this.route.address().url().host(), this.source, this.sink).protocol(this.protocol).listener(this).build();
            framedConnection.start();
            this.allocationLimit = framedConnection.maxConcurrentStreams();
            this.framedConnection = framedConnection;
            return;
        }
        this.allocationLimit = 1;
    }

    private void connectTls(int n2, int n3, ConnectionSpecSelector object) throws IOException {
        Address address = this.route.address();
        Object object2 = address.sslSocketFactory();
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)((SSLSocketFactory)object2).createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
            object2 = ((ConnectionSpecSelector)object).configureSecureSocket(sSLSocket);
            if (((ConnectionSpec)object2).supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sSLSocket, address.url().host(), address.protocols());
            }
            sSLSocket.startHandshake();
            object = Handshake.get(sSLSocket.getSession());
            if (!address.hostnameVerifier().verify(address.url().host(), sSLSocket.getSession())) {
                object2 = (X509Certificate)((Handshake)object).peerCertificates().get(0);
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified:\n    certificate: " + CertificatePinner.pin((Certificate)object2) + "\n    DN: " + ((X509Certificate)object2).getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames((X509Certificate)object2));
            }
            address.certificatePinner().check(address.url().host(), ((Handshake)object).peerCertificates());
            object2 = ((ConnectionSpec)object2).supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sSLSocket) : null;
            this.socket = sSLSocket;
            this.source = Okio.buffer(Okio.source(this.socket));
            this.sink = Okio.buffer(Okio.sink(this.socket));
            this.handshake = object;
            Protocol protocol = this.protocol = object2 != null ? Protocol.get((String)object2) : Protocol.HTTP_1_1;
            if (sSLSocket != null) {
                Platform.get().afterHandshake(sSLSocket);
            }
            return;
        }
        catch (AssertionError assertionError) {
            try {
                object2 = assertionError;
                if (Util.isAndroidGetsocknameError(assertionError)) {
                    throw new IOException((Throwable)object2);
                }
                throw object2;
            }
            catch (Throwable throwable) {
                if (sSLSocket != null) {
                    Platform.get().afterHandshake(sSLSocket);
                }
                Util.closeQuietly(sSLSocket);
                throw throwable;
            }
        }
    }

    private Request createTunnel(int n2, int n3, Request object, HttpUrl object2) throws IOException {
        Response response;
        object2 = "CONNECT " + Util.hostHeader((HttpUrl)object2, true) + " HTTP/1.1";
        block4: while (true) {
            Http1xStream http1xStream = new Http1xStream(null, this.source, this.sink);
            this.source.timeout().timeout(n2, TimeUnit.MILLISECONDS);
            this.sink.timeout().timeout(n3, TimeUnit.MILLISECONDS);
            http1xStream.writeRequest(((Request)object).headers(), (String)object2);
            http1xStream.finishRequest();
            response = http1xStream.readResponse().request((Request)object).build();
            long l2 = OkHeaders.contentLength(response);
            if (l2 == -1L) {
                l2 = 0L;
            }
            object = http1xStream.newFixedLengthSource(l2);
            Util.skipAll((Source)object, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            object.close();
            switch (response.code()) {
                case 200: {
                    if (!this.source.buffer().exhausted() || !this.sink.buffer().exhausted()) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return null;
                }
                case 407: {
                    object = this.route.address().proxyAuthenticator().authenticate(this.route, response);
                    if (object != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                    if (!"close".equalsIgnoreCase(response.header("Connection"))) continue block4;
                    return object;
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private Request createTunnelRequest() throws IOException {
        return new Request$Builder().url(this.route.address().url()).header("Host", Util.hostHeader(this.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
    }

    final boolean isConnected() {
        return this.protocol != null;
    }

    @Override
    public final Route route() {
        return this.route;
    }

    public final void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    @Override
    public final Socket socket() {
        return this.socket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isHealthy(boolean bl) {
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        if (this.framedConnection != null) {
            return true;
        }
        if (!bl) return true;
        try {
            int n2 = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (!this.source.exhausted()) return true;
                return false;
            }
            finally {
                this.socket.setSoTimeout(n2);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public final void onStream(FramedStream framedStream) throws IOException {
        framedStream.close(ErrorCode.REFUSED_STREAM);
    }

    @Override
    public final void onSettings(FramedConnection framedConnection) {
        this.allocationLimit = framedConnection.maxConcurrentStreams();
    }

    @Override
    public final Handshake handshake() {
        return this.handshake;
    }

    public final boolean isMultiplexed() {
        return this.framedConnection != null;
    }

    @Override
    public final Protocol protocol() {
        if (this.framedConnection == null) {
            if (this.protocol != null) {
                return this.protocol;
            }
            return Protocol.HTTP_1_1;
        }
        return this.framedConnection.getProtocol();
    }

    public final String toString() {
        return "Connection{" + this.route.address().url().host() + ":" + this.route.address().url().port() + ", proxy=" + this.route.proxy() + " hostAddress=" + this.route.socketAddress() + " cipherSuite=" + (this.handshake != null ? this.handshake.cipherSuite() : "none") + " protocol=" + (Object)((Object)this.protocol) + '}';
    }
}

