/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Timeout;
import java.io.IOException;
import java.net.ProtocolException;

public final class RetryableSink
implements Sink {
    private boolean closed;
    private final int limit;
    private final Buffer content = new Buffer();

    public RetryableSink(int n2) {
        this.limit = n2;
    }

    public RetryableSink() {
        this(-1);
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.content.size() < (long)this.limit) {
            throw new ProtocolException("content-length promised " + this.limit + " bytes, but received " + this.content.size());
        }
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Util.checkOffsetAndCount(buffer.size(), 0L, l2);
        if (this.limit != -1 && this.content.size() > (long)this.limit - l2) {
            throw new ProtocolException("exceeded content-length limit of " + this.limit + " bytes");
        }
        this.content.write(buffer, l2);
    }

    @Override
    public final void flush() throws IOException {
    }

    @Override
    public final Timeout timeout() {
        return Timeout.NONE;
    }

    public final long contentLength() throws IOException {
        return this.content.size();
    }

    public final void writeToSocket(Sink sink) throws IOException {
        Buffer buffer = new Buffer();
        this.content.copyTo(buffer, 0L, this.content.size());
        sink.write(buffer, buffer.size());
    }
}

