/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Headers$Builder;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.Response$Builder;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import com.zoyi.retrofit2.okhttp3.internal.Internal;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream$ChunkedSink;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream$ChunkedSource;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream$FixedLengthSink;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream$FixedLengthSource;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream$UnknownLengthSource;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpStream;
import com.zoyi.retrofit2.okhttp3.internal.http.OkHeaders;
import com.zoyi.retrofit2.okhttp3.internal.http.RealResponseBody;
import com.zoyi.retrofit2.okhttp3.internal.http.RequestLine;
import com.zoyi.retrofit2.okhttp3.internal.http.RetryableSink;
import com.zoyi.retrofit2.okhttp3.internal.http.StatusLine;
import com.zoyi.retrofit2.okhttp3.internal.http.StreamAllocation;
import com.zoyi.retrofit2.okhttp3.internal.io.RealConnection;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.ForwardingTimeout;
import com.zoyi.retrofit2.okio.Okio;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Source;
import com.zoyi.retrofit2.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;

public final class Http1xStream
implements HttpStream {
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    private final StreamAllocation streamAllocation;
    private final BufferedSource source;
    private final BufferedSink sink;
    private HttpEngine httpEngine;
    private int state = 0;

    public Http1xStream(StreamAllocation streamAllocation, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.streamAllocation = streamAllocation;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    @Override
    public final void setHttpEngine(HttpEngine httpEngine) {
        this.httpEngine = httpEngine;
    }

    @Override
    public final Sink createRequestBody(Request request, long l2) throws IOException {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l2 != -1L) {
            return this.newFixedLengthSink(l2);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public final void cancel() {
        RealConnection realConnection = this.streamAllocation.connection();
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    @Override
    public final void writeRequestHeaders(Request request) throws IOException {
        this.httpEngine.writingRequestHeaders();
        String string = RequestLine.get(request, this.httpEngine.getConnection().route().proxy().type());
        this.writeRequest(request.headers(), string);
    }

    @Override
    public final Response$Builder readResponseHeaders() throws IOException {
        return this.readResponse();
    }

    @Override
    public final ResponseBody openResponseBody(Response response) throws IOException {
        Source source = this.getTransferStream(response);
        return new RealResponseBody(response.headers(), Okio.buffer(source));
    }

    private Source getTransferStream(Response response) throws IOException {
        if (!HttpEngine.hasBody(response)) {
            return this.newFixedLengthSource(0L);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return this.newChunkedSource(this.httpEngine);
        }
        long l2 = OkHeaders.contentLength(response);
        if (l2 != -1L) {
            return this.newFixedLengthSource(l2);
        }
        return this.newUnknownLengthSource();
    }

    public final boolean isClosed() {
        return this.state == 6;
    }

    @Override
    public final void finishRequest() throws IOException {
        this.sink.flush();
    }

    public final void writeRequest(Headers headers, String string) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.sink.writeUtf8(string).writeUtf8("\r\n");
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sink.writeUtf8(headers.name(i2)).writeUtf8(": ").writeUtf8(headers.value(i2)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    public final Response$Builder readResponse() throws IOException {
        if (this.state != 1 && this.state != 3) {
            throw new IllegalStateException("state: " + this.state);
        }
        try {
            Response$Builder response$Builder;
            StatusLine statusLine;
            do {
                statusLine = StatusLine.parse(this.source.readUtf8LineStrict());
                response$Builder = new Response$Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
            } while (statusLine.code == 100);
            this.state = 4;
            return response$Builder;
        }
        catch (EOFException eOFException) {
            IOException iOException = new IOException("unexpected end of stream on " + this.streamAllocation);
            iOException.initCause(eOFException);
            throw iOException;
        }
    }

    public final Headers readHeaders() throws IOException {
        String string;
        Headers$Builder headers$Builder = new Headers$Builder();
        while ((string = this.source.readUtf8LineStrict()).length() != 0) {
            Internal.instance.addLenient(headers$Builder, string);
        }
        return headers$Builder.build();
    }

    public final Sink newChunkedSink() {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new Http1xStream$ChunkedSink(this, null);
    }

    public final Sink newFixedLengthSink(long l2) {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new Http1xStream$FixedLengthSink(this, l2, null);
    }

    @Override
    public final void writeRequestBody(RetryableSink retryableSink) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 3;
        retryableSink.writeToSocket(this.sink);
    }

    public final Source newFixedLengthSource(long l2) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new Http1xStream$FixedLengthSource(this, l2);
    }

    public final Source newChunkedSource(HttpEngine httpEngine) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new Http1xStream$ChunkedSource(this, httpEngine);
    }

    public final Source newUnknownLengthSource() throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        if (this.streamAllocation == null) {
            throw new IllegalStateException("streamAllocation == null");
        }
        this.state = 5;
        this.streamAllocation.noNewStreams();
        return new Http1xStream$UnknownLengthSource(this, null);
    }

    private void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    static /* synthetic */ BufferedSink access$300(Http1xStream http1xStream) {
        return http1xStream.sink;
    }

    static /* synthetic */ void access$400(Http1xStream http1xStream, ForwardingTimeout forwardingTimeout) {
        http1xStream.detachTimeout(forwardingTimeout);
    }

    static /* synthetic */ int access$502(Http1xStream http1xStream, int n2) {
        http1xStream.state = n2;
        return http1xStream.state;
    }

    static /* synthetic */ BufferedSource access$600(Http1xStream http1xStream) {
        return http1xStream.source;
    }

    static /* synthetic */ int access$500(Http1xStream http1xStream) {
        return http1xStream.state;
    }

    static /* synthetic */ StreamAllocation access$700(Http1xStream http1xStream) {
        return http1xStream.streamAllocation;
    }
}

