/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameWriter;
import com.zoyi.retrofit2.okhttp3.internal.framed.Header;
import com.zoyi.retrofit2.okhttp3.internal.framed.Settings;
import com.zoyi.retrofit2.okhttp3.internal.framed.Spdy3;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.DeflaterSink;
import com.zoyi.retrofit2.okio.Okio;
import com.zoyi.retrofit2.okio.Sink;
import java.io.IOException;
import java.util.List;
import java.util.zip.Deflater;

final class Spdy3$Writer
implements FrameWriter {
    private final BufferedSink sink;
    private final Buffer headerBlockBuffer;
    private final BufferedSink headerBlockOut;
    private final boolean client;
    private boolean closed;

    Spdy3$Writer(BufferedSink object, boolean bl) {
        this.sink = object;
        this.client = bl;
        object = new Deflater();
        ((Deflater)object).setDictionary(Spdy3.DICTIONARY);
        this.headerBlockBuffer = new Buffer();
        this.headerBlockOut = Okio.buffer(new DeflaterSink((Sink)this.headerBlockBuffer, (Deflater)object));
    }

    @Override
    public final void ackSettings(Settings settings) {
    }

    @Override
    public final void pushPromise(int n2, int n3, List<Header> list) throws IOException {
    }

    @Override
    public final synchronized void connectionPreface() {
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void synStream(boolean bl, boolean bl2, int n2, int n3, List<Header> list) throws IOException {
        void var4_5;
        void var3_4;
        void var2_3;
        void n4;
        if (this.closed) {
            throw new IOException("closed");
        }
        this.writeNameValueBlockToBuffer((List<Header>)n4);
        int n5 = (int)(10L + this.headerBlockBuffer.size());
        int n6 = (bl ? 1 : 0) | (var2_3 != false ? 2 : 0);
        this.sink.writeInt(-2147287039);
        this.sink.writeInt((n6 & 0xFF) << 24 | n5 & 0xFFFFFF);
        this.sink.writeInt((int)(var3_4 & Integer.MAX_VALUE));
        this.sink.writeInt((int)(var4_5 & Integer.MAX_VALUE));
        this.sink.writeShort(0);
        this.sink.writeAll(this.headerBlockBuffer);
        this.sink.flush();
    }

    @Override
    public final synchronized void synReply(boolean bl, int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.writeNameValueBlockToBuffer(list);
        bl = bl;
        int n3 = (int)(this.headerBlockBuffer.size() + 4L);
        this.sink.writeInt(-2147287038);
        this.sink.writeInt((bl & 0xFF) << 24 | n3 & 0xFFFFFF);
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
        this.sink.writeAll(this.headerBlockBuffer);
        this.sink.flush();
    }

    @Override
    public final synchronized void headers(int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.writeNameValueBlockToBuffer(list);
        int n3 = (int)(this.headerBlockBuffer.size() + 4L);
        this.sink.writeInt(-2147287032);
        this.sink.writeInt(0 | n3 & 0xFFFFFF);
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
        this.sink.writeAll(this.headerBlockBuffer);
    }

    @Override
    public final synchronized void rstStream(int n2, ErrorCode errorCode) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.spdyRstCode == -1) {
            throw new IllegalArgumentException();
        }
        this.sink.writeInt(-2147287037);
        this.sink.writeInt(8);
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
        this.sink.writeInt(errorCode.spdyRstCode);
        this.sink.flush();
    }

    @Override
    public final int maxDataLength() {
        return 16383;
    }

    @Override
    public final synchronized void data(boolean bl, int n2, Buffer buffer, int n3) throws IOException {
        bl = bl;
        this.sendDataFrame(n2, bl ? 1 : 0, buffer, n3);
    }

    final void sendDataFrame(int n2, int n3, Buffer buffer, int n4) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if ((long)n4 > 0xFFFFFFL) {
            throw new IllegalArgumentException("FRAME_TOO_LARGE max size is 16Mib: " + n4);
        }
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
        this.sink.writeInt((n3 & 0xFF) << 24 | n4 & 0xFFFFFF);
        if (n4 > 0) {
            this.sink.write(buffer, (long)n4);
        }
    }

    private void writeNameValueBlockToBuffer(List<Header> list) throws IOException {
        this.headerBlockOut.writeInt(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = list.get((int)i2).name;
            this.headerBlockOut.writeInt(byteString.size());
            this.headerBlockOut.write(byteString);
            byteString = list.get((int)i2).value;
            this.headerBlockOut.writeInt(byteString.size());
            this.headerBlockOut.write(byteString);
        }
        this.headerBlockOut.flush();
    }

    @Override
    public final synchronized void settings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n2 = settings.size();
        int n3 = 4 + (n2 << 3);
        this.sink.writeInt(-2147287036);
        this.sink.writeInt(0 | n3 & 0xFFFFFF);
        this.sink.writeInt(n2);
        for (n2 = 0; n2 <= 10; ++n2) {
            if (!settings.isSet(n2)) continue;
            n3 = settings.flags(n2);
            this.sink.writeInt((n3 & 0xFF) << 24 | n2 & 0xFFFFFF);
            this.sink.writeInt(settings.get(n2));
        }
        this.sink.flush();
    }

    @Override
    public final synchronized void ping(boolean n2, int n3, int n4) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n5 = n4 = this.client != ((n3 & 1) == 1) ? 1 : 0;
        if (n2 != n4) {
            throw new IllegalArgumentException("payload != reply");
        }
        this.sink.writeInt(-2147287034);
        this.sink.writeInt(4);
        this.sink.writeInt(n3);
        this.sink.flush();
    }

    @Override
    public final synchronized void goAway(int n2, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.spdyGoAwayCode == -1) {
            throw new IllegalArgumentException("errorCode.spdyGoAwayCode == -1");
        }
        this.sink.writeInt(-2147287033);
        this.sink.writeInt(8);
        this.sink.writeInt(n2);
        this.sink.writeInt(errorCode.spdyGoAwayCode);
        this.sink.flush();
    }

    @Override
    public final synchronized void windowUpdate(int n2, long l2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (l2 == 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("windowSizeIncrement must be between 1 and 0x7fffffff: " + l2);
        }
        this.sink.writeInt(-2147287031);
        this.sink.writeInt(8);
        this.sink.writeInt(n2);
        this.sink.writeInt((int)l2);
        this.sink.flush();
    }

    @Override
    public final synchronized void close() throws IOException {
        this.closed = true;
        Util.closeAll(this.sink, this.headerBlockOut);
    }
}

