/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameReader;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameReader$Handler;
import com.zoyi.retrofit2.okhttp3.internal.framed.Header;
import com.zoyi.retrofit2.okhttp3.internal.framed.HeadersMode;
import com.zoyi.retrofit2.okhttp3.internal.framed.NameValueBlockReader;
import com.zoyi.retrofit2.okhttp3.internal.framed.Settings;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.ByteString;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.List;

final class Spdy3$Reader
implements FrameReader {
    private final BufferedSource source;
    private final boolean client;
    private final NameValueBlockReader headerBlockReader;

    Spdy3$Reader(BufferedSource bufferedSource, boolean bl) {
        this.source = bufferedSource;
        this.headerBlockReader = new NameValueBlockReader(this.source);
        this.client = bl;
    }

    @Override
    public final void readConnectionPreface() {
    }

    @Override
    public final boolean nextFrame(FrameReader$Handler frameReader$Handler) throws IOException {
        int n2;
        int n3;
        try {
            n3 = this.source.readInt();
            n2 = this.source.readInt();
        }
        catch (IOException iOException) {
            return false;
        }
        int n4 = (n3 & Integer.MIN_VALUE) != 0 ? 1 : 0;
        int n5 = (n2 & 0xFF000000) >>> 24;
        n2 &= 0xFFFFFF;
        if (n4 != 0) {
            n4 = (n3 & 0x7FFF0000) >>> 16;
            n3 &= 0xFFFF;
            if (n4 != 3) {
                throw new ProtocolException("version != 3: " + n4);
            }
            switch (n3) {
                case 1: {
                    this.readSynStream(frameReader$Handler, n5, n2);
                    return true;
                }
                case 2: {
                    this.readSynReply(frameReader$Handler, n5, n2);
                    return true;
                }
                case 3: {
                    this.readRstStream(frameReader$Handler, n5, n2);
                    return true;
                }
                case 4: {
                    this.readSettings(frameReader$Handler, n5, n2);
                    return true;
                }
                case 6: {
                    this.readPing(frameReader$Handler, n5, n2);
                    return true;
                }
                case 7: {
                    this.readGoAway(frameReader$Handler, n5, n2);
                    return true;
                }
                case 8: {
                    this.readHeaders(frameReader$Handler, n5, n2);
                    return true;
                }
                case 9: {
                    this.readWindowUpdate(frameReader$Handler, n5, n2);
                    return true;
                }
            }
            this.source.skip(n2);
            return true;
        }
        n4 = n3 & Integer.MAX_VALUE;
        n3 = (n5 & 1) != 0 ? 1 : 0;
        frameReader$Handler.data(n3 != 0, n4, this.source, n2);
        return true;
    }

    private void readSynStream(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        int n4 = this.source.readInt();
        int n5 = this.source.readInt();
        n4 &= Integer.MAX_VALUE;
        n5 &= Integer.MAX_VALUE;
        this.source.readShort();
        List<Header> list = this.headerBlockReader.readNameValueBlock(n3 - 10);
        boolean bl = (n2 & 1) != 0;
        n2 = (n2 & 2) != 0 ? 1 : 0;
        frameReader$Handler.headers(n2 != 0, bl, n4, n5, list, HeadersMode.SPDY_SYN_STREAM);
    }

    private void readSynReply(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        int n4 = this.source.readInt();
        List<Header> list = this.headerBlockReader.readNameValueBlock(n3 - 4);
        n2 = (n2 & 1) != 0 ? 1 : 0;
        frameReader$Handler.headers(false, n2 != 0, n4 &= Integer.MAX_VALUE, -1, list, HeadersMode.SPDY_REPLY);
    }

    private void readRstStream(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        if (n3 != 8) {
            throw Spdy3$Reader.ioException("TYPE_RST_STREAM length: %d != 8", n3);
        }
        n2 = this.source.readInt() & Integer.MAX_VALUE;
        n3 = this.source.readInt();
        ErrorCode errorCode = ErrorCode.fromSpdy3Rst(n3);
        if (errorCode == null) {
            throw Spdy3$Reader.ioException("TYPE_RST_STREAM unexpected error code: %d", n3);
        }
        frameReader$Handler.rstStream(n2, errorCode);
    }

    private void readHeaders(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        n2 = this.source.readInt();
        List<Header> list = this.headerBlockReader.readNameValueBlock(n3 - 4);
        frameReader$Handler.headers(false, false, n2 &= Integer.MAX_VALUE, -1, list, HeadersMode.SPDY_HEADERS);
    }

    private void readWindowUpdate(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        if (n3 != 8) {
            throw Spdy3$Reader.ioException("TYPE_WINDOW_UPDATE length: %d != 8", n3);
        }
        n2 = this.source.readInt();
        n3 = this.source.readInt();
        n2 &= Integer.MAX_VALUE;
        long l2 = n3 & Integer.MAX_VALUE;
        if (l2 == 0L) {
            throw Spdy3$Reader.ioException("windowSizeIncrement was 0", l2);
        }
        frameReader$Handler.windowUpdate(n2, l2);
    }

    private void readPing(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        if (n3 != 4) {
            throw Spdy3$Reader.ioException("TYPE_PING length: %d != 4", n3);
        }
        n2 = this.source.readInt();
        n3 = this.client == ((n2 & 1) == 1) ? 1 : 0;
        frameReader$Handler.ping(n3 != 0, n2, 0);
    }

    private void readGoAway(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        if (n3 != 8) {
            throw Spdy3$Reader.ioException("TYPE_GOAWAY length: %d != 8", n3);
        }
        n2 = this.source.readInt() & Integer.MAX_VALUE;
        n3 = this.source.readInt();
        ErrorCode errorCode = ErrorCode.fromSpdyGoAway(n3);
        if (errorCode == null) {
            throw Spdy3$Reader.ioException("TYPE_GOAWAY unexpected error code: %d", n3);
        }
        frameReader$Handler.goAway(n2, errorCode, ByteString.EMPTY);
    }

    private void readSettings(FrameReader$Handler frameReader$Handler, int n2, int n3) throws IOException {
        int n4;
        int n5 = this.source.readInt();
        if (n3 != 4 + n5 * 8) {
            throw Spdy3$Reader.ioException("TYPE_SETTINGS length: %d != 4 + 8 * %d", n3, n5);
        }
        Settings settings = new Settings();
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = this.source.readInt();
            int n7 = this.source.readInt();
            int n8 = (n6 & 0xFF000000) >>> 24;
            settings.set(n6 &= 0xFFFFFF, n8, n7);
        }
        n4 = (n2 & 1) != 0 ? 1 : 0;
        frameReader$Handler.settings(n4 != 0, settings);
    }

    private static IOException ioException(String string, Object ... objectArray) throws IOException {
        throw new IOException(Util.format(string, objectArray));
    }

    @Override
    public final void close() throws IOException {
        this.headerBlockReader.close();
    }
}

