/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okio.ByteString;

public final class Header {
    public static final ByteString RESPONSE_STATUS = ByteString.encodeUtf8(":status");
    public static final ByteString TARGET_METHOD = ByteString.encodeUtf8(":method");
    public static final ByteString TARGET_PATH = ByteString.encodeUtf8(":path");
    public static final ByteString TARGET_SCHEME = ByteString.encodeUtf8(":scheme");
    public static final ByteString TARGET_AUTHORITY = ByteString.encodeUtf8(":authority");
    public static final ByteString TARGET_HOST = ByteString.encodeUtf8(":host");
    public static final ByteString VERSION = ByteString.encodeUtf8(":version");
    public final ByteString name;
    public final ByteString value;
    final int hpackSize;

    public Header(String string, String string2) {
        this(ByteString.encodeUtf8(string), ByteString.encodeUtf8(string2));
    }

    public Header(ByteString byteString, String string) {
        this(byteString, ByteString.encodeUtf8(string));
    }

    public Header(ByteString byteString, ByteString byteString2) {
        this.name = byteString;
        this.value = byteString2;
        this.hpackSize = 32 + byteString.size() + byteString2.size();
    }

    public final boolean equals(Object object) {
        if (object instanceof Header) {
            object = (Header)object;
            return this.name.equals(((Header)object).name) && this.value.equals(((Header)object).value);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = 527 + this.name.hashCode();
        n2 = n2 * 31 + this.value.hashCode();
        return n2;
    }

    public final String toString() {
        return Util.format("%s: %s", this.name.utf8(), this.value.utf8());
    }
}

