/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.FrameWriter;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$1;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$2;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$3;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$4;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$5;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$6;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$7;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$Builder;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$Listener;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection$Reader;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedStream;
import com.zoyi.retrofit2.okhttp3.internal.framed.Header;
import com.zoyi.retrofit2.okhttp3.internal.framed.Http2;
import com.zoyi.retrofit2.okhttp3.internal.framed.Ping;
import com.zoyi.retrofit2.okhttp3.internal.framed.PushObserver;
import com.zoyi.retrofit2.okhttp3.internal.framed.Settings;
import com.zoyi.retrofit2.okhttp3.internal.framed.Spdy3;
import com.zoyi.retrofit2.okhttp3.internal.framed.Variant;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class FramedConnection
implements Closeable {
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp FramedConnection", true));
    final Protocol protocol;
    final boolean client;
    private final FramedConnection$Listener listener;
    private final Map<Integer, FramedStream> streams = new HashMap<Integer, FramedStream>();
    private final String hostname;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean shutdown;
    private long idleStartTimeNs = System.nanoTime();
    private final ExecutorService pushExecutor;
    private Map<Integer, Ping> pings;
    private final PushObserver pushObserver;
    private int nextPingId;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    final Settings peerSettings = new Settings();
    private boolean receivedInitialPeerSettings = false;
    final Variant variant;
    final Socket socket;
    final FrameWriter frameWriter;
    final FramedConnection$Reader readerRunnable;
    private final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    private FramedConnection(FramedConnection$Builder framedConnection$Builder) throws IOException {
        this.protocol = FramedConnection$Builder.access$000(framedConnection$Builder);
        this.pushObserver = FramedConnection$Builder.access$100(framedConnection$Builder);
        this.client = FramedConnection$Builder.access$200(framedConnection$Builder);
        this.listener = FramedConnection$Builder.access$300(framedConnection$Builder);
        int n2 = this.nextStreamId = FramedConnection$Builder.access$200(framedConnection$Builder) ? 1 : 2;
        if (FramedConnection$Builder.access$200(framedConnection$Builder) && this.protocol == Protocol.HTTP_2) {
            this.nextStreamId += 2;
        }
        int n3 = this.nextPingId = FramedConnection$Builder.access$200(framedConnection$Builder) ? 1 : 2;
        if (FramedConnection$Builder.access$200(framedConnection$Builder)) {
            this.okHttpSettings.set(7, 0, 0x1000000);
        }
        this.hostname = FramedConnection$Builder.access$400(framedConnection$Builder);
        if (this.protocol == Protocol.HTTP_2) {
            this.variant = new Http2();
            this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.hostname), true));
            this.peerSettings.set(7, 0, 65535);
            this.peerSettings.set(5, 0, 16384);
        } else if (this.protocol == Protocol.SPDY_3) {
            this.variant = new Spdy3();
            this.pushExecutor = null;
        } else {
            throw new AssertionError((Object)this.protocol);
        }
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize(65536);
        this.socket = FramedConnection$Builder.access$500(framedConnection$Builder);
        this.frameWriter = this.variant.newWriter(FramedConnection$Builder.access$600(framedConnection$Builder), this.client);
        this.readerRunnable = new FramedConnection$Reader(this, this.variant.newReader(FramedConnection$Builder.access$700(framedConnection$Builder), this.client), null);
    }

    public final Protocol getProtocol() {
        return this.protocol;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    final synchronized FramedStream getStream(int n2) {
        return this.streams.get(n2);
    }

    final synchronized FramedStream removeStream(int n2) {
        FramedStream framedStream = this.streams.remove(n2);
        if (framedStream != null && this.streams.isEmpty()) {
            this.setIdle(true);
        }
        this.notifyAll();
        return framedStream;
    }

    private synchronized void setIdle(boolean bl) {
        this.idleStartTimeNs = bl ? System.nanoTime() : Long.MAX_VALUE;
    }

    public final synchronized boolean isIdle() {
        return this.idleStartTimeNs != Long.MAX_VALUE;
    }

    public final synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    public final synchronized long getIdleStartTimeNs() {
        return this.idleStartTimeNs;
    }

    public final FramedStream pushStream(int n2, List<Header> list, boolean bl) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        if (this.protocol != Protocol.HTTP_2) {
            throw new IllegalStateException("protocol != HTTP_2");
        }
        return this.newStream(n2, list, bl, false);
    }

    public final FramedStream newStream(List<Header> list, boolean bl, boolean bl2) throws IOException {
        return this.newStream(0, list, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FramedStream newStream(int n2, List<Header> list, boolean bl, boolean bl2) throws IOException {
        FramedStream framedStream;
        boolean bl3 = !bl;
        bl2 = !bl2;
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int n3;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                n3 = this.nextStreamId;
                this.nextStreamId += 2;
                framedStream = new FramedStream(n3, this, bl3, bl2, list);
                boolean bl4 = bl = !bl || this.bytesLeftInWriteWindow == 0L || framedStream.bytesLeftInWriteWindow == 0L;
                if (framedStream.isOpen()) {
                    this.streams.put(n3, framedStream);
                    this.setIdle(false);
                }
            }
            if (n2 == 0) {
                this.frameWriter.synStream(bl3, bl2, n3, n2, list);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.frameWriter.pushPromise(n2, n3, list);
            }
        }
        if (bl) {
            this.frameWriter.flush();
        }
        return framedStream;
    }

    final void writeSynReply(int n2, boolean bl, List<Header> list) throws IOException {
        this.frameWriter.synReply(bl, n2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int n2, boolean bl, Buffer buffer, long l2) throws IOException {
        if (l2 == 0L) {
            this.frameWriter.data(bl, n2, buffer, 0);
            return;
        }
        while (l2 > 0L) {
            int n3;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(n2)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                n3 = (int)Math.min(l2, this.bytesLeftInWriteWindow);
                n3 = Math.min(n3, this.frameWriter.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)n3;
            }
            this.frameWriter.data(bl && (l2 -= (long)n3) == 0L, n2, buffer, n3);
        }
    }

    final void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    final void writeSynResetLater(int n2, ErrorCode errorCode) {
        executor.submit(new FramedConnection$1(this, "OkHttp %s stream %d", new Object[]{this.hostname, n2}, n2, errorCode));
    }

    final void writeSynReset(int n2, ErrorCode errorCode) throws IOException {
        this.frameWriter.rstStream(n2, errorCode);
    }

    final void writeWindowUpdateLater(int n2, long l2) {
        executor.execute(new FramedConnection$2(this, "OkHttp Window Update %s stream %d", new Object[]{this.hostname, n2}, n2, l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Ping ping() throws IOException {
        int n2;
        Ping ping = new Ping();
        FramedConnection framedConnection = this;
        synchronized (framedConnection) {
            if (this.shutdown) {
                throw new IOException("shutdown");
            }
            n2 = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new HashMap<Integer, Ping>();
            }
            this.pings.put(n2, ping);
        }
        this.writePing(false, n2, 1330343787, ping);
        return ping;
    }

    private void writePingLater(boolean bl, int n2, int n3, Ping ping) {
        executor.execute(new FramedConnection$3(this, "OkHttp %s ping %08x%08x", new Object[]{this.hostname, n2, n3}, bl, n2, n3, ping));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing(boolean bl, int n2, int n3, Ping ping) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            if (ping != null) {
                ping.send();
            }
            this.frameWriter.ping(bl, n2, n3);
            return;
        }
    }

    private synchronized Ping removePing(int n2) {
        if (this.pings != null) {
            return this.pings.remove(n2);
        }
        return null;
    }

    public final void flush() throws IOException {
        this.frameWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(ErrorCode errorCode) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int n2;
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n2 = this.lastGoodStreamId;
            }
            this.frameWriter.goAway(n2, errorCode, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ErrorCode framedStreamArray, ErrorCode errorCode) throws IOException {
        IOException iOException;
        block19: {
            int n2;
            assert (!Thread.holdsLock(this));
            iOException = null;
            try {
                this.shutdown((ErrorCode)((Object)framedStreamArray));
            }
            catch (IOException iOException2) {
                framedStreamArray = iOException2;
                iOException = iOException2;
            }
            framedStreamArray = null;
            Ping[] pingArray = null;
            FramedConnection object = this;
            synchronized (object) {
                if (!this.streams.isEmpty()) {
                    framedStreamArray = this.streams.values().toArray(new FramedStream[this.streams.size()]);
                    this.streams.clear();
                    this.setIdle(false);
                }
                if (this.pings != null) {
                    pingArray = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
            }
            if (framedStreamArray != null) {
                Object iOException4 = framedStreamArray;
                int n3 = ((FramedStream[])framedStreamArray).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    FramedStream framedStream = iOException4[n2];
                    try {
                        framedStream.close(errorCode);
                        continue;
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) continue;
                        iOException = iOException3;
                    }
                }
            }
            if (pingArray != null) {
                Ping[] pingArray2 = pingArray;
                int n22 = pingArray.length;
                for (n2 = 0; n2 < n22; ++n2) {
                    Ping ping = pingArray2[n2];
                    ping.cancel();
                }
            }
            try {
                this.frameWriter.close();
            }
            catch (IOException iOException4) {
                if (iOException != null) break block19;
                iOException = iOException4;
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException5) {
            IOException iOException6 = iOException5;
            iOException = iOException5;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public final void start() throws IOException {
        this.start(true);
    }

    final void start(boolean n2) throws IOException {
        if (n2) {
            this.frameWriter.connectionPreface();
            this.frameWriter.settings(this.okHttpSettings);
            n2 = this.okHttpSettings.getInitialWindowSize(65536);
            if (n2 != 65536) {
                this.frameWriter.windowUpdate(0, n2 - 65536);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(Settings settings) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            FramedConnection framedConnection = this;
            synchronized (framedConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                this.okHttpSettings.merge(settings);
                this.frameWriter.settings(settings);
            }
            return;
        }
    }

    private boolean pushedStream(int n2) {
        return this.protocol == Protocol.HTTP_2 && n2 != 0 && (n2 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushRequestLater(int n2, List<Header> list) {
        FramedConnection framedConnection = this;
        synchronized (framedConnection) {
            if (this.currentPushRequests.contains(n2)) {
                this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n2);
        }
        this.pushExecutor.execute(new FramedConnection$4(this, "OkHttp %s Push Request[%s]", new Object[]{this.hostname, n2}, n2, list));
    }

    private void pushHeadersLater(int n2, List<Header> list, boolean bl) {
        this.pushExecutor.execute(new FramedConnection$5(this, "OkHttp %s Push Headers[%s]", new Object[]{this.hostname, n2}, n2, list, bl));
    }

    private void pushDataLater(int n2, BufferedSource bufferedSource, int n3, boolean bl) throws IOException {
        Buffer buffer = new Buffer();
        bufferedSource.require(n3);
        bufferedSource.read(buffer, n3);
        if (buffer.size() != (long)n3) {
            throw new IOException(buffer.size() + " != " + n3);
        }
        this.pushExecutor.execute(new FramedConnection$6(this, "OkHttp %s Push Data[%s]", new Object[]{this.hostname, n2}, n2, buffer, n3, bl));
    }

    private void pushResetLater(int n2, ErrorCode errorCode) {
        this.pushExecutor.execute(new FramedConnection$7(this, "OkHttp %s Push Reset[%s]", new Object[]{this.hostname, n2}, n2, errorCode));
    }

    static /* synthetic */ void access$900(FramedConnection framedConnection, boolean bl, int n2, int n3, Ping ping) throws IOException {
        framedConnection.writePing(bl, n2, n3, ping);
    }

    /* synthetic */ FramedConnection(FramedConnection$Builder framedConnection$Builder, FramedConnection$1 framedConnection$1) throws IOException {
        this(framedConnection$Builder);
    }

    static /* synthetic */ String access$1100(FramedConnection framedConnection) {
        return framedConnection.hostname;
    }

    static /* synthetic */ void access$1200(FramedConnection framedConnection, ErrorCode errorCode, ErrorCode errorCode2) throws IOException {
        framedConnection.close(errorCode, errorCode2);
    }

    static /* synthetic */ boolean access$1300(FramedConnection framedConnection, int n2) {
        return framedConnection.pushedStream(n2);
    }

    static /* synthetic */ void access$1400(FramedConnection framedConnection, int n2, BufferedSource bufferedSource, int n3, boolean bl) throws IOException {
        framedConnection.pushDataLater(n2, bufferedSource, n3, bl);
    }

    static /* synthetic */ void access$1500(FramedConnection framedConnection, int n2, List list, boolean bl) {
        framedConnection.pushHeadersLater(n2, list, bl);
    }

    static /* synthetic */ boolean access$1600(FramedConnection framedConnection) {
        return framedConnection.shutdown;
    }

    static /* synthetic */ int access$1700(FramedConnection framedConnection) {
        return framedConnection.lastGoodStreamId;
    }

    static /* synthetic */ int access$1800(FramedConnection framedConnection) {
        return framedConnection.nextStreamId;
    }

    static /* synthetic */ int access$1702(FramedConnection framedConnection, int n2) {
        framedConnection.lastGoodStreamId = n2;
        return framedConnection.lastGoodStreamId;
    }

    static /* synthetic */ Map access$1900(FramedConnection framedConnection) {
        return framedConnection.streams;
    }

    static /* synthetic */ FramedConnection$Listener access$2000(FramedConnection framedConnection) {
        return framedConnection.listener;
    }

    static /* synthetic */ ExecutorService access$2100() {
        return executor;
    }

    static /* synthetic */ void access$2200(FramedConnection framedConnection, int n2, ErrorCode errorCode) {
        framedConnection.pushResetLater(n2, errorCode);
    }

    static /* synthetic */ boolean access$2300(FramedConnection framedConnection) {
        return framedConnection.receivedInitialPeerSettings;
    }

    static /* synthetic */ boolean access$2302(FramedConnection framedConnection, boolean bl) {
        framedConnection.receivedInitialPeerSettings = bl;
        return framedConnection.receivedInitialPeerSettings;
    }

    static /* synthetic */ Ping access$2400(FramedConnection framedConnection, int n2) {
        return framedConnection.removePing(n2);
    }

    static /* synthetic */ void access$2500(FramedConnection framedConnection, boolean bl, int n2, int n3, Ping ping) {
        framedConnection.writePingLater(bl, n2, n3, ping);
    }

    static /* synthetic */ boolean access$1602(FramedConnection framedConnection, boolean bl) {
        framedConnection.shutdown = bl;
        return framedConnection.shutdown;
    }

    static /* synthetic */ void access$2600(FramedConnection framedConnection, int n2, List list) {
        framedConnection.pushRequestLater(n2, list);
    }

    static /* synthetic */ PushObserver access$2700(FramedConnection framedConnection) {
        return framedConnection.pushObserver;
    }

    static /* synthetic */ Set access$2800(FramedConnection framedConnection) {
        return framedConnection.currentPushRequests;
    }
}

