/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal;

import android.util.Log;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.internal.OptionalMethod;
import com.zoyi.retrofit2.okhttp3.internal.Platform;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;

    public AndroidPlatform(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
        this.sslParametersClass = clazz;
        this.setUseSessionTickets = optionalMethod;
        this.setHostname = optionalMethod2;
        this.getAlpnSelectedProtocol = optionalMethod3;
        this.setAlpnProtocols = optionalMethod4;
    }

    @Override
    public void connectSocket(Socket object, InetSocketAddress serializable, int n2) throws IOException {
        try {
            ((Socket)object).connect((SocketAddress)serializable, n2);
            return;
        }
        catch (AssertionError assertionError) {
            object = assertionError;
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)object);
            }
            throw object;
        }
        catch (SecurityException securityException) {
            serializable = new IOException("Exception in connect");
            ((Throwable)serializable).initCause(securityException);
            throw serializable;
        }
    }

    @Override
    public X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        Object object;
        Object object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, this.sslParametersClass, "sslParameters");
        if (object2 == null) {
            try {
                object = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sSLSocketFactory.getClass().getClassLoader());
                object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, object, "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager(sSLSocketFactory);
            }
        }
        if ((object = AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "x509TrustManager")) != null) {
            return object;
        }
        return AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String objectArray, List<Protocol> list) {
        if (objectArray != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sSLSocket, true);
            this.setHostname.invokeOptionalWithoutCheckedException(sSLSocket, new Object[]{objectArray});
        }
        if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sSLSocket)) {
            objectArray = new Object[]{AndroidPlatform.concatLengthPrefixed(list)};
            this.setAlpnProtocols.invokeWithoutCheckedException(sSLSocket, objectArray);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket object) {
        if (this.getAlpnSelectedProtocol == null) {
            return null;
        }
        if (!this.getAlpnSelectedProtocol.isSupported((Socket)object)) {
            return null;
        }
        byte[] byArray = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException((Socket)object, new Object[0]);
        object = byArray;
        if (byArray != null) {
            return new String((byte[])object, Util.UTF_8);
        }
        return null;
    }

    @Override
    public void log(int n2, String string, Throwable throwable) {
        int n3 = n2 = n2 == 5 ? 5 : 3;
        if (throwable != null) {
            string = string + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = string.indexOf(10, i2);
            n6 = n6 != -1 ? n6 : n4;
            do {
                n5 = Math.min(n6, i2 + 4000);
                Log.println((int)n2, (String)"OkHttp", (String)string.substring(i2, n5));
            } while ((i2 = n5) < n6);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted() {
        try {
            GenericDeclaration genericDeclaration = Class.forName("android.security.NetworkSecurityPolicy");
            Object object = genericDeclaration.getMethod("getInstance", new Class[0]);
            object = ((Method)object).invoke(null, new Object[0]);
            genericDeclaration = genericDeclaration.getMethod("isCleartextTrafficPermitted", new Class[0]);
            boolean bl = (Boolean)((Method)genericDeclaration).invoke(object, new Object[0]);
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.isCleartextTrafficPermitted();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            throw new AssertionError();
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> optionalMethod = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> optionalMethod2 = new OptionalMethod<Socket>(null, "setHostname", String.class);
            OptionalMethod optionalMethod3 = null;
            OptionalMethod optionalMethod4 = null;
            try {
                Class.forName("android.net.Network");
                optionalMethod3 = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                optionalMethod4 = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return new AndroidPlatform(clazz, optionalMethod, optionalMethod2, optionalMethod3, optionalMethod4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

