/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.ResponseBody$1;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    public final byte[] bytes() throws IOException {
        byte[] byArray;
        long l2 = this.contentLength();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + l2);
        }
        BufferedSource bufferedSource = this.source();
        try {
            byArray = bufferedSource.readByteArray();
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
        if (l2 != -1L && l2 != (long)byArray.length) {
            throw new IOException("Content-Length and stream length disagree");
        }
        return byArray;
    }

    public final Reader charStream() {
        Reader reader = this.reader;
        if (reader != null) {
            return reader;
        }
        this.reader = new InputStreamReader(this.byteStream(), this.charset());
        return this.reader;
    }

    public final String string() throws IOException {
        return new String(this.bytes(), this.charset().name());
    }

    private Charset charset() {
        MediaType mediaType = this.contentType();
        if (mediaType != null) {
            return mediaType.charset(Util.UTF_8);
        }
        return Util.UTF_8;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    public static ResponseBody create(MediaType mediaType, String object) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        object = new Buffer().writeString((String)object, charset);
        return ResponseBody.create(mediaType, ((Buffer)object).size(), (BufferedSource)object);
    }

    public static ResponseBody create(MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, buffer);
    }

    public static ResponseBody create(MediaType mediaType, long l2, BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody$1(mediaType, l2, bufferedSource);
    }
}

