/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.RequestBody$1;
import com.zoyi.retrofit2.okhttp3.RequestBody$2;
import com.zoyi.retrofit2.okhttp3.RequestBody$3;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.ByteString;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class RequestBody {
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;

    public static RequestBody create(MediaType mediaType, String object) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        object = ((String)object).getBytes(charset);
        return RequestBody.create(mediaType, (byte[])object);
    }

    public static RequestBody create(MediaType mediaType, ByteString byteString) {
        return new RequestBody$1(mediaType, byteString);
    }

    public static RequestBody create(MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(MediaType mediaType, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("content == null");
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        return new RequestBody$2(mediaType, n3, byArray, n2);
    }

    public static RequestBody create(MediaType mediaType, File file) {
        if (file == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody$3(mediaType, file);
    }
}

