/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Call;
import com.zoyi.retrofit2.okhttp3.Callback;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.OkHttpClient;
import com.zoyi.retrofit2.okhttp3.RealCall$ApplicationInterceptorChain;
import com.zoyi.retrofit2.okhttp3.RealCall$AsyncCall;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Request$Builder;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine;
import com.zoyi.retrofit2.okhttp3.internal.http.RequestException;
import com.zoyi.retrofit2.okhttp3.internal.http.RouteException;
import com.zoyi.retrofit2.okhttp3.internal.http.StreamAllocation;
import java.io.IOException;
import java.net.ProtocolException;

final class RealCall
implements Call {
    private final OkHttpClient client;
    private boolean executed;
    volatile boolean canceled;
    Request originalRequest;
    HttpEngine engine;

    protected RealCall(OkHttpClient okHttpClient, Request request) {
        this.client = okHttpClient;
        this.originalRequest = request;
    }

    @Override
    public final Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Response execute() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        try {
            this.client.dispatcher().executed(this);
            object = this.getResponseWithInterceptorChain(false);
            if (object == null) {
                throw new IOException("Canceled");
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    final Object tag() {
        return this.originalRequest.tag();
    }

    @Override
    public final void enqueue(Callback callback) {
        this.enqueue(callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enqueue(Callback callback, boolean bl) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.client.dispatcher().enqueue(new RealCall$AsyncCall(this, callback, bl, null));
    }

    @Override
    public final void cancel() {
        this.canceled = true;
        if (this.engine != null) {
            this.engine.cancel();
        }
    }

    @Override
    public final synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public final boolean isCanceled() {
        return this.canceled;
    }

    private String toLoggableString() {
        String string = this.canceled ? "canceled call" : "call";
        return string + " to " + this.redactedUrl();
    }

    final HttpUrl redactedUrl() {
        return this.originalRequest.url().resolve("/...");
    }

    private Response getResponseWithInterceptorChain(boolean bl) throws IOException {
        RealCall$ApplicationInterceptorChain realCall$ApplicationInterceptorChain = new RealCall$ApplicationInterceptorChain(this, 0, this.originalRequest, bl);
        return realCall$ApplicationInterceptorChain.proceed(this.originalRequest);
    }

    final Response getResponse(Request object, boolean bl) throws IOException {
        Object object2 = ((Request)object).body();
        if (object2 != null) {
            long l2;
            Request$Builder request$Builder = ((Request)object).newBuilder();
            object = ((RequestBody)object2).contentType();
            if (object != null) {
                request$Builder.header("Content-Type", ((MediaType)object).toString());
            }
            if ((l2 = ((RequestBody)object2).contentLength()) != -1L) {
                request$Builder.header("Content-Length", Long.toString(l2));
                request$Builder.removeHeader("Transfer-Encoding");
            } else {
                request$Builder.header("Transfer-Encoding", "chunked");
                request$Builder.removeHeader("Content-Length");
            }
            object = request$Builder.build();
        }
        this.engine = new HttpEngine(this.client, (Request)object, false, false, bl, null, null, null);
        int n2 = 0;
        while (true) {
            Object object3;
            if (this.canceled) {
                this.engine.releaseStreamAllocation();
                throw new IOException("Canceled");
            }
            boolean bl2 = true;
            try {
                try {
                    this.engine.sendRequest();
                    this.engine.readResponse();
                }
                catch (RequestException requestException) {
                    RequestException requestException2 = requestException;
                    throw requestException.getCause();
                }
                catch (RouteException routeException) {
                    object3 = this.engine.recover(routeException.getLastConnectException(), true, null);
                    if (object3 != null) {
                        bl2 = false;
                        this.engine = object3;
                        continue;
                    }
                    throw routeException.getLastConnectException();
                }
                catch (IOException iOException) {
                    object3 = this.engine.recover(iOException, false, null);
                    if (object3 != null) {
                        bl2 = false;
                        this.engine = object3;
                        continue;
                    }
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                if (bl2) {
                    StreamAllocation streamAllocation = this.engine.close();
                    streamAllocation.release();
                }
                throw throwable;
            }
            Response response = this.engine.getResponse();
            object3 = this.engine.followUpRequest();
            if (object3 == null) {
                if (!bl) {
                    this.engine.releaseStreamAllocation();
                }
                return response;
            }
            object2 = this.engine.close();
            if (++n2 > 20) {
                ((StreamAllocation)object2).release();
                throw new ProtocolException("Too many follow-up requests: " + n2);
            }
            if (!this.engine.sameConnection(((Request)object3).url())) {
                ((StreamAllocation)object2).release();
                object2 = null;
            } else if (((StreamAllocation)object2).stream() != null) {
                throw new IllegalStateException("Closing the body of " + response + " didn't close its backing stream. Bad interceptor?");
            }
            Object object4 = object3;
            this.engine = new HttpEngine(this.client, (Request)object4, false, false, bl, (StreamAllocation)object2, null, response);
        }
    }

    static /* synthetic */ Response access$100(RealCall realCall, boolean bl) throws IOException {
        return realCall.getResponseWithInterceptorChain(bl);
    }

    static /* synthetic */ String access$200(RealCall realCall) {
        return realCall.toLoggableString();
    }

    static /* synthetic */ OkHttpClient access$300(RealCall realCall) {
        return realCall.client;
    }
}

