/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Authenticator;
import com.zoyi.retrofit2.okhttp3.Cache;
import com.zoyi.retrofit2.okhttp3.CertificatePinner;
import com.zoyi.retrofit2.okhttp3.ConnectionPool;
import com.zoyi.retrofit2.okhttp3.ConnectionSpec;
import com.zoyi.retrofit2.okhttp3.CookieJar;
import com.zoyi.retrofit2.okhttp3.Dispatcher;
import com.zoyi.retrofit2.okhttp3.Dns;
import com.zoyi.retrofit2.okhttp3.Interceptor;
import com.zoyi.retrofit2.okhttp3.OkHttpClient;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.internal.InternalCache;
import com.zoyi.retrofit2.okhttp3.internal.Platform;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.tls.CertificateChainCleaner;
import com.zoyi.retrofit2.okhttp3.internal.tls.OkHostnameVerifier;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public final class OkHttpClient$Builder {
    Dispatcher dispatcher;
    Proxy proxy;
    List<Protocol> protocols;
    List<ConnectionSpec> connectionSpecs;
    final List<Interceptor> interceptors = new ArrayList<Interceptor>();
    final List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
    ProxySelector proxySelector;
    CookieJar cookieJar;
    Cache cache;
    InternalCache internalCache;
    SocketFactory socketFactory;
    SSLSocketFactory sslSocketFactory;
    CertificateChainCleaner certificateChainCleaner;
    HostnameVerifier hostnameVerifier;
    CertificatePinner certificatePinner;
    Authenticator proxyAuthenticator;
    Authenticator authenticator;
    ConnectionPool connectionPool;
    Dns dns;
    boolean followSslRedirects;
    boolean followRedirects;
    boolean retryOnConnectionFailure;
    int connectTimeout;
    int readTimeout;
    int writeTimeout;

    public OkHttpClient$Builder() {
        this.dispatcher = new Dispatcher();
        this.protocols = OkHttpClient.access$000();
        this.connectionSpecs = OkHttpClient.access$100();
        this.proxySelector = ProxySelector.getDefault();
        this.cookieJar = CookieJar.NO_COOKIES;
        this.socketFactory = SocketFactory.getDefault();
        this.hostnameVerifier = OkHostnameVerifier.INSTANCE;
        this.certificatePinner = CertificatePinner.DEFAULT;
        this.proxyAuthenticator = Authenticator.NONE;
        this.authenticator = Authenticator.NONE;
        this.connectionPool = new ConnectionPool();
        this.dns = Dns.SYSTEM;
        this.followSslRedirects = true;
        this.followRedirects = true;
        this.retryOnConnectionFailure = true;
        this.connectTimeout = 10000;
        this.readTimeout = 10000;
        this.writeTimeout = 10000;
    }

    OkHttpClient$Builder(OkHttpClient okHttpClient) {
        this.dispatcher = okHttpClient.dispatcher;
        this.proxy = okHttpClient.proxy;
        this.protocols = okHttpClient.protocols;
        this.connectionSpecs = okHttpClient.connectionSpecs;
        this.interceptors.addAll(okHttpClient.interceptors);
        this.networkInterceptors.addAll(okHttpClient.networkInterceptors);
        this.proxySelector = okHttpClient.proxySelector;
        this.cookieJar = okHttpClient.cookieJar;
        this.internalCache = okHttpClient.internalCache;
        this.cache = okHttpClient.cache;
        this.socketFactory = okHttpClient.socketFactory;
        this.sslSocketFactory = okHttpClient.sslSocketFactory;
        this.certificateChainCleaner = okHttpClient.certificateChainCleaner;
        this.hostnameVerifier = okHttpClient.hostnameVerifier;
        this.certificatePinner = okHttpClient.certificatePinner;
        this.proxyAuthenticator = okHttpClient.proxyAuthenticator;
        this.authenticator = okHttpClient.authenticator;
        this.connectionPool = okHttpClient.connectionPool;
        this.dns = okHttpClient.dns;
        this.followSslRedirects = okHttpClient.followSslRedirects;
        this.followRedirects = okHttpClient.followRedirects;
        this.retryOnConnectionFailure = okHttpClient.retryOnConnectionFailure;
        this.connectTimeout = okHttpClient.connectTimeout;
        this.readTimeout = okHttpClient.readTimeout;
        this.writeTimeout = okHttpClient.writeTimeout;
    }

    public final OkHttpClient$Builder connectTimeout(long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit == null");
        }
        long l3 = timeUnit.toMillis(l2);
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout too large.");
        }
        if (l3 == 0L && l2 > 0L) {
            throw new IllegalArgumentException("Timeout too small.");
        }
        this.connectTimeout = (int)l3;
        return this;
    }

    public final OkHttpClient$Builder readTimeout(long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit == null");
        }
        long l3 = timeUnit.toMillis(l2);
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout too large.");
        }
        if (l3 == 0L && l2 > 0L) {
            throw new IllegalArgumentException("Timeout too small.");
        }
        this.readTimeout = (int)l3;
        return this;
    }

    public final OkHttpClient$Builder writeTimeout(long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit == null");
        }
        long l3 = timeUnit.toMillis(l2);
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout too large.");
        }
        if (l3 == 0L && l2 > 0L) {
            throw new IllegalArgumentException("Timeout too small.");
        }
        this.writeTimeout = (int)l3;
        return this;
    }

    public final OkHttpClient$Builder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public final OkHttpClient$Builder proxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    public final OkHttpClient$Builder cookieJar(CookieJar cookieJar) {
        if (cookieJar == null) {
            throw new NullPointerException("cookieJar == null");
        }
        this.cookieJar = cookieJar;
        return this;
    }

    final void setInternalCache(InternalCache internalCache) {
        this.internalCache = internalCache;
        this.cache = null;
    }

    public final OkHttpClient$Builder cache(Cache cache) {
        this.cache = cache;
        this.internalCache = null;
        return this;
    }

    public final OkHttpClient$Builder dns(Dns dns) {
        if (dns == null) {
            throw new NullPointerException("dns == null");
        }
        this.dns = dns;
        return this;
    }

    public final OkHttpClient$Builder socketFactory(SocketFactory socketFactory) {
        if (socketFactory == null) {
            throw new NullPointerException("socketFactory == null");
        }
        this.socketFactory = socketFactory;
        return this;
    }

    public final OkHttpClient$Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new NullPointerException("sslSocketFactory == null");
        }
        X509TrustManager x509TrustManager = Platform.get().trustManager(sSLSocketFactory);
        if (x509TrustManager == null) {
            throw new IllegalStateException("Unable to extract the trust manager on " + Platform.get() + ", sslSocketFactory is " + sSLSocketFactory.getClass());
        }
        this.sslSocketFactory = sSLSocketFactory;
        this.certificateChainCleaner = CertificateChainCleaner.get(x509TrustManager);
        return this;
    }

    public final OkHttpClient$Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory, X509TrustManager x509TrustManager) {
        if (sSLSocketFactory == null) {
            throw new NullPointerException("sslSocketFactory == null");
        }
        if (x509TrustManager == null) {
            throw new NullPointerException("trustManager == null");
        }
        this.sslSocketFactory = sSLSocketFactory;
        this.certificateChainCleaner = CertificateChainCleaner.get(x509TrustManager);
        return this;
    }

    public final OkHttpClient$Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new NullPointerException("hostnameVerifier == null");
        }
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public final OkHttpClient$Builder certificatePinner(CertificatePinner certificatePinner) {
        if (certificatePinner == null) {
            throw new NullPointerException("certificatePinner == null");
        }
        this.certificatePinner = certificatePinner;
        return this;
    }

    public final OkHttpClient$Builder authenticator(Authenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("authenticator == null");
        }
        this.authenticator = authenticator;
        return this;
    }

    public final OkHttpClient$Builder proxyAuthenticator(Authenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("proxyAuthenticator == null");
        }
        this.proxyAuthenticator = authenticator;
        return this;
    }

    public final OkHttpClient$Builder connectionPool(ConnectionPool connectionPool) {
        if (connectionPool == null) {
            throw new NullPointerException("connectionPool == null");
        }
        this.connectionPool = connectionPool;
        return this;
    }

    public final OkHttpClient$Builder followSslRedirects(boolean bl) {
        this.followSslRedirects = bl;
        return this;
    }

    public final OkHttpClient$Builder followRedirects(boolean bl) {
        this.followRedirects = bl;
        return this;
    }

    public final OkHttpClient$Builder retryOnConnectionFailure(boolean bl) {
        this.retryOnConnectionFailure = bl;
        return this;
    }

    public final OkHttpClient$Builder dispatcher(Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new IllegalArgumentException("dispatcher == null");
        }
        this.dispatcher = dispatcher;
        return this;
    }

    public final OkHttpClient$Builder protocols(List<Protocol> list) {
        if (!(list = Util.immutableList(list)).contains((Object)Protocol.HTTP_1_1)) {
            throw new IllegalArgumentException("protocols doesn't contain http/1.1: " + list);
        }
        if (list.contains((Object)Protocol.HTTP_1_0)) {
            throw new IllegalArgumentException("protocols must not contain http/1.0: " + list);
        }
        if (list.contains(null)) {
            throw new IllegalArgumentException("protocols must not contain null");
        }
        this.protocols = Util.immutableList(list);
        return this;
    }

    public final OkHttpClient$Builder connectionSpecs(List<ConnectionSpec> list) {
        this.connectionSpecs = Util.immutableList(list);
        return this;
    }

    public final List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public final OkHttpClient$Builder addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public final List<Interceptor> networkInterceptors() {
        return this.networkInterceptors;
    }

    public final OkHttpClient$Builder addNetworkInterceptor(Interceptor interceptor) {
        this.networkInterceptors.add(interceptor);
        return this;
    }

    public final OkHttpClient build() {
        return new OkHttpClient(this, null);
    }
}

