/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.MultipartBody;
import com.zoyi.retrofit2.okhttp3.MultipartBody$Part;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.retrofit2.okio.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class MultipartBody$Builder {
    private final ByteString boundary;
    private MediaType type = MultipartBody.MIXED;
    private final List<MultipartBody$Part> parts = new ArrayList<MultipartBody$Part>();

    public MultipartBody$Builder() {
        this(UUID.randomUUID().toString());
    }

    public MultipartBody$Builder(String string) {
        this.boundary = ByteString.encodeUtf8(string);
    }

    public final MultipartBody$Builder setType(MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("type == null");
        }
        if (!mediaType.type().equals("multipart")) {
            throw new IllegalArgumentException("multipart != " + mediaType);
        }
        this.type = mediaType;
        return this;
    }

    public final MultipartBody$Builder addPart(RequestBody requestBody) {
        return this.addPart(MultipartBody$Part.create(requestBody));
    }

    public final MultipartBody$Builder addPart(Headers headers, RequestBody requestBody) {
        return this.addPart(MultipartBody$Part.create(headers, requestBody));
    }

    public final MultipartBody$Builder addFormDataPart(String string, String string2) {
        return this.addPart(MultipartBody$Part.createFormData(string, string2));
    }

    public final MultipartBody$Builder addFormDataPart(String string, String string2, RequestBody requestBody) {
        return this.addPart(MultipartBody$Part.createFormData(string, string2, requestBody));
    }

    public final MultipartBody$Builder addPart(MultipartBody$Part multipartBody$Part) {
        if (multipartBody$Part == null) {
            throw new NullPointerException("part == null");
        }
        this.parts.add(multipartBody$Part);
        return this;
    }

    public final MultipartBody build() {
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("Multipart body must have at least one part.");
        }
        return new MultipartBody(this.boundary, this.type, this.parts);
    }
}

