/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.CipherSuite;
import com.zoyi.retrofit2.okhttp3.TlsVersion;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class Handshake {
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List<Certificate> peerCertificates;
    private final List<Certificate> localCertificates;

    private Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.peerCertificates = list;
        this.localCertificates = list2;
    }

    public static Handshake get(SSLSession object) {
        Object object2;
        Object object3 = object.getCipherSuite();
        if (object3 == null) {
            throw new IllegalStateException("cipherSuite == null");
        }
        object3 = CipherSuite.forJavaName(object3);
        Object object4 = object.getProtocol();
        if (object4 == null) {
            throw new IllegalStateException("tlsVersion == null");
        }
        object4 = TlsVersion.forJavaName(object4);
        try {
            object2 = object.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            object2 = null;
        }
        object2 = object2 != null ? Util.immutableList(object2) : Collections.emptyList();
        object = object.getLocalCertificates();
        object = object != null ? Util.immutableList(object) : Collections.emptyList();
        return new Handshake((TlsVersion)((Object)object4), (CipherSuite)((Object)object3), (List<Certificate>)object2, (List<Certificate>)object);
    }

    public static Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        if (cipherSuite == null) {
            throw new NullPointerException("cipherSuite == null");
        }
        return new Handshake(tlsVersion, cipherSuite, Util.immutableList(list), Util.immutableList(list2));
    }

    public final TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    public final CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    public final List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    public final Principal peerPrincipal() {
        if (!this.peerCertificates.isEmpty()) {
            return ((X509Certificate)this.peerCertificates.get(0)).getSubjectX500Principal();
        }
        return null;
    }

    public final List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    public final Principal localPrincipal() {
        if (!this.localCertificates.isEmpty()) {
            return ((X509Certificate)this.localCertificates.get(0)).getSubjectX500Principal();
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Handshake)) {
            return false;
        }
        object = (Handshake)object;
        return Util.equal((Object)this.cipherSuite, (Object)((Handshake)object).cipherSuite) && this.cipherSuite.equals((Object)((Handshake)object).cipherSuite) && this.peerCertificates.equals(((Handshake)object).peerCertificates) && this.localCertificates.equals(((Handshake)object).localCertificates);
    }

    public final int hashCode() {
        int n2 = 527 + (this.tlsVersion != null ? this.tlsVersion.hashCode() : 0);
        n2 = n2 * 31 + this.cipherSuite.hashCode();
        n2 = n2 * 31 + this.peerCertificates.hashCode();
        n2 = n2 * 31 + this.localCertificates.hashCode();
        return n2;
    }
}

