/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Cache$1;
import com.zoyi.retrofit2.okhttp3.Cache$2;
import com.zoyi.retrofit2.okhttp3.Cache$CacheRequestImpl;
import com.zoyi.retrofit2.okhttp3.Cache$CacheResponseBody;
import com.zoyi.retrofit2.okhttp3.Cache$Entry;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.internal.DiskLruCache;
import com.zoyi.retrofit2.okhttp3.internal.DiskLruCache$Editor;
import com.zoyi.retrofit2.okhttp3.internal.DiskLruCache$Snapshot;
import com.zoyi.retrofit2.okhttp3.internal.InternalCache;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.http.CacheRequest;
import com.zoyi.retrofit2.okhttp3.internal.http.CacheStrategy;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpMethod;
import com.zoyi.retrofit2.okhttp3.internal.http.OkHeaders;
import com.zoyi.retrofit2.okhttp3.internal.io.FileSystem;
import com.zoyi.retrofit2.okio.BufferedSource;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;

public final class Cache
implements Closeable,
Flushable {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final InternalCache internalCache = new Cache$1(this);
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public Cache(File file, long l2) {
        this(file, l2, FileSystem.SYSTEM);
    }

    Cache(File file, long l2, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l2);
    }

    private static String urlToKey(Request request) {
        return Util.md5Hex(request.url().toString());
    }

    final Response get(Request request) {
        Cache$Entry cache$Entry;
        Object object = Cache.urlToKey(request);
        try {
            object = this.cache.get((String)object);
            if (object == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            cache$Entry = new Cache$Entry(((DiskLruCache$Snapshot)object).getSource(0));
        }
        catch (IOException iOException) {
            Util.closeQuietly((Closeable)object);
            return null;
        }
        object = cache$Entry.response((DiskLruCache$Snapshot)object);
        if (!cache$Entry.matches(request, (Response)object)) {
            Util.closeQuietly(((Response)object).body());
            return null;
        }
        return object;
    }

    private CacheRequest put(Response response) throws IOException {
        Object object = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove(response.request());
            }
            catch (IOException iOException) {}
            return null;
        }
        if (!((String)object).equals("GET")) {
            return null;
        }
        if (OkHeaders.hasVaryAll(response)) {
            return null;
        }
        object = new Cache$Entry(response);
        DiskLruCache$Editor diskLruCache$Editor = null;
        try {
            diskLruCache$Editor = this.cache.edit(Cache.urlToKey(response.request()));
            if (diskLruCache$Editor == null) {
                return null;
            }
            ((Cache$Entry)object).writeTo(diskLruCache$Editor);
            return new Cache$CacheRequestImpl(this, diskLruCache$Editor);
        }
        catch (IOException iOException) {
            this.abortQuietly(diskLruCache$Editor);
            return null;
        }
    }

    private void remove(Request request) throws IOException {
        this.cache.remove(Cache.urlToKey(request));
    }

    private void update(Response closeable, Response object) {
        object = new Cache$Entry((Response)object);
        closeable = Cache$CacheResponseBody.access$500((Cache$CacheResponseBody)((Response)closeable).body());
        DiskLruCache$Editor diskLruCache$Editor = null;
        try {
            diskLruCache$Editor = ((DiskLruCache$Snapshot)closeable).edit();
            if (diskLruCache$Editor != null) {
                ((Cache$Entry)object).writeTo(diskLruCache$Editor);
                diskLruCache$Editor.commit();
            }
            return;
        }
        catch (IOException iOException) {
            this.abortQuietly(diskLruCache$Editor);
            return;
        }
    }

    private void abortQuietly(DiskLruCache$Editor diskLruCache$Editor) {
        try {
            if (diskLruCache$Editor != null) {
                diskLruCache$Editor.abort();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public final Iterator<String> urls() throws IOException {
        return new Cache$2(this);
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public final void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public final void close() throws IOException {
        this.cache.close();
    }

    public final File directory() {
        return this.cache.getDirectory();
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    private synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (cacheStrategy.networkRequest != null) {
            ++this.networkCount;
            return;
        }
        if (cacheStrategy.cacheResponse != null) {
            ++this.hitCount;
        }
    }

    private synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public final synchronized int networkCount() {
        return this.networkCount;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int requestCount() {
        return this.requestCount;
    }

    private static int readInt(BufferedSource object) throws IOException {
        try {
            long l2 = object.readDecimalLong();
            object = object.readUtf8LineStrict();
            if (l2 < 0L || l2 > Integer.MAX_VALUE || !((String)object).isEmpty()) {
                throw new IOException("expected an int but was \"" + l2 + (String)object + "\"");
            }
            return (int)l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    static /* synthetic */ CacheRequest access$000(Cache cache, Response response) throws IOException {
        return cache.put(response);
    }

    static /* synthetic */ void access$100(Cache cache, Request request) throws IOException {
        cache.remove(request);
    }

    static /* synthetic */ void access$200(Cache cache, Response response, Response response2) {
        cache.update(response, response2);
    }

    static /* synthetic */ void access$300(Cache cache) {
        cache.trackConditionalCacheHit();
    }

    static /* synthetic */ void access$400(Cache cache, CacheStrategy cacheStrategy) {
        cache.trackResponse(cacheStrategy);
    }

    static /* synthetic */ DiskLruCache access$600(Cache cache) {
        return cache.cache;
    }

    static /* synthetic */ int access$808(Cache cache) {
        return cache.writeSuccessCount++;
    }

    static /* synthetic */ int access$908(Cache cache) {
        return cache.writeAbortCount++;
    }

    static /* synthetic */ int access$1000(BufferedSource bufferedSource) throws IOException {
        return Cache.readInt(bufferedSource);
    }
}

