/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Cache;
import com.zoyi.retrofit2.okhttp3.Cache$CacheResponseBody;
import com.zoyi.retrofit2.okhttp3.CipherSuite;
import com.zoyi.retrofit2.okhttp3.Handshake;
import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Headers$Builder;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Request$Builder;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.Response$Builder;
import com.zoyi.retrofit2.okhttp3.TlsVersion;
import com.zoyi.retrofit2.okhttp3.internal.DiskLruCache$Editor;
import com.zoyi.retrofit2.okhttp3.internal.DiskLruCache$Snapshot;
import com.zoyi.retrofit2.okhttp3.internal.http.OkHeaders;
import com.zoyi.retrofit2.okhttp3.internal.http.StatusLine;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.BufferedSink;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.Okio;
import com.zoyi.retrofit2.okio.Source;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class Cache$Entry {
    private final String url;
    private final Headers varyHeaders;
    private final String requestMethod;
    private final Protocol protocol;
    private final int code;
    private final String message;
    private final Headers responseHeaders;
    private final Handshake handshake;
    private final long sentRequestMillis;
    private final long receivedResponseMillis;

    public Cache$Entry(Source source) throws IOException {
        try {
            BufferedSource bufferedSource = Okio.buffer(source);
            this.url = bufferedSource.readUtf8LineStrict();
            this.requestMethod = bufferedSource.readUtf8LineStrict();
            Object object = new Headers$Builder();
            int n2 = Cache.access$1000(bufferedSource);
            for (int i2 = 0; i2 < n2; ++i2) {
                ((Headers$Builder)object).addLenient(bufferedSource.readUtf8LineStrict());
            }
            this.varyHeaders = ((Headers$Builder)object).build();
            StatusLine statusLine = StatusLine.parse(bufferedSource.readUtf8LineStrict());
            this.protocol = statusLine.protocol;
            this.code = statusLine.code;
            this.message = statusLine.message;
            object = new Headers$Builder();
            n2 = Cache.access$1000(bufferedSource);
            for (int i3 = 0; i3 < n2; ++i3) {
                ((Headers$Builder)object).addLenient(bufferedSource.readUtf8LineStrict());
            }
            Object object2 = ((Headers$Builder)object).get(OkHeaders.SENT_MILLIS);
            Object object3 = ((Headers$Builder)object).get(OkHeaders.RECEIVED_MILLIS);
            ((Headers$Builder)object).removeAll(OkHeaders.SENT_MILLIS);
            ((Headers$Builder)object).removeAll(OkHeaders.RECEIVED_MILLIS);
            this.sentRequestMillis = object2 != null ? Long.parseLong((String)object2) : 0L;
            this.receivedResponseMillis = object3 != null ? Long.parseLong((String)object3) : 0L;
            this.responseHeaders = ((Headers$Builder)object).build();
            if (this.isHttps()) {
                object = bufferedSource.readUtf8LineStrict();
                if (((String)object).length() > 0) {
                    throw new IOException("expected \"\" but was \"" + (String)object + "\"");
                }
                object = bufferedSource.readUtf8LineStrict();
                object = CipherSuite.forJavaName((String)object);
                object3 = this.readCertificateList(bufferedSource);
                object2 = this.readCertificateList(bufferedSource);
                bufferedSource = !bufferedSource.exhausted() ? TlsVersion.forJavaName(bufferedSource.readUtf8LineStrict()) : null;
                this.handshake = Handshake.get((TlsVersion)((Object)bufferedSource), (CipherSuite)((Object)object), (List<Certificate>)object3, (List<Certificate>)object2);
            } else {
                this.handshake = null;
            }
            return;
        }
        finally {
            source.close();
        }
    }

    public Cache$Entry(Response response) {
        this.url = response.request().url().toString();
        this.varyHeaders = OkHeaders.varyHeaders(response);
        this.requestMethod = response.request().method();
        this.protocol = response.protocol();
        this.code = response.code();
        this.message = response.message();
        this.responseHeaders = response.headers();
        this.handshake = response.handshake();
        this.sentRequestMillis = response.sentRequestAtMillis();
        this.receivedResponseMillis = response.receivedResponseAtMillis();
    }

    public final void writeTo(DiskLruCache$Editor object) throws IOException {
        int n2;
        object = Okio.buffer(((DiskLruCache$Editor)object).newSink(0));
        object.writeUtf8(this.url).writeByte(10);
        object.writeUtf8(this.requestMethod).writeByte(10);
        object.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
        int n3 = this.varyHeaders.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object.writeUtf8(this.varyHeaders.name(n2)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(n2)).writeByte(10);
        }
        object.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
        object.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
        n3 = this.responseHeaders.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object.writeUtf8(this.responseHeaders.name(n2)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(n2)).writeByte(10);
        }
        object.writeUtf8(OkHeaders.SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
        object.writeUtf8(OkHeaders.RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
        if (this.isHttps()) {
            object.writeByte(10);
            object.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
            this.writeCertList((BufferedSink)object, this.handshake.peerCertificates());
            this.writeCertList((BufferedSink)object, this.handshake.localCertificates());
            if (this.handshake.tlsVersion() != null) {
                object.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
        }
        object.close();
    }

    private boolean isHttps() {
        return this.url.startsWith("https://");
    }

    private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
        int n2 = Cache.access$1000(bufferedSource);
        if (n2 == -1) {
            return Collections.emptyList();
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = bufferedSource.readUtf8LineStrict();
                Buffer buffer = new Buffer();
                buffer.write(ByteString.decodeBase64(string));
                arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
            }
            return arrayList;
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException.getMessage());
        }
    }

    private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
        try {
            bufferedSink.writeDecimalLong(list.size()).writeByte(10);
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = list.get(i2).getEncoded();
                object = ByteString.of(object).base64();
                bufferedSink.writeUtf8((String)object).writeByte(10);
            }
            return;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException(certificateEncodingException.getMessage());
        }
    }

    public final boolean matches(Request request, Response response) {
        return this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && OkHeaders.varyMatches(response, this.varyHeaders, request);
    }

    public final Response response(DiskLruCache$Snapshot diskLruCache$Snapshot) {
        String string = this.responseHeaders.get("Content-Type");
        String string2 = this.responseHeaders.get("Content-Length");
        Request request = new Request$Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
        return new Response$Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new Cache$CacheResponseBody(diskLruCache$Snapshot, string, string2)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
    }
}

