/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.BuiltInConverters;
import com.zoyi.retrofit2.CallAdapter$Factory;
import com.zoyi.retrofit2.Converter$Factory;
import com.zoyi.retrofit2.Platform;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.Utils;
import com.zoyi.retrofit2.okhttp3.Call$Factory;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.OkHttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public final class Retrofit$Builder {
    private Platform platform;
    private Call$Factory callFactory;
    private HttpUrl baseUrl;
    private List<Converter$Factory> converterFactories = new ArrayList<Converter$Factory>();
    private List<CallAdapter$Factory> adapterFactories = new ArrayList<CallAdapter$Factory>();
    private Executor callbackExecutor;
    private boolean validateEagerly;

    Retrofit$Builder(Platform platform) {
        this.platform = platform;
        this.converterFactories.add(new BuiltInConverters());
    }

    public Retrofit$Builder() {
        this(Platform.get());
    }

    public final Retrofit$Builder client(OkHttpClient okHttpClient) {
        return this.callFactory(Utils.checkNotNull(okHttpClient, "client == null"));
    }

    public final Retrofit$Builder callFactory(Call$Factory call$Factory) {
        this.callFactory = Utils.checkNotNull(call$Factory, "factory == null");
        return this;
    }

    public final Retrofit$Builder baseUrl(String string) {
        Utils.checkNotNull(string, "baseUrl == null");
        HttpUrl httpUrl = HttpUrl.parse(string);
        if (httpUrl == null) {
            throw new IllegalArgumentException("Illegal URL: " + string);
        }
        return this.baseUrl(httpUrl);
    }

    public final Retrofit$Builder baseUrl(HttpUrl httpUrl) {
        Utils.checkNotNull(httpUrl, "baseUrl == null");
        List<String> list = httpUrl.pathSegments();
        if (!"".equals(list.get(list.size() - 1))) {
            throw new IllegalArgumentException("baseUrl must end in /: " + httpUrl);
        }
        this.baseUrl = httpUrl;
        return this;
    }

    public final Retrofit$Builder addConverterFactory(Converter$Factory converter$Factory) {
        this.converterFactories.add(Utils.checkNotNull(converter$Factory, "factory == null"));
        return this;
    }

    public final Retrofit$Builder addCallAdapterFactory(CallAdapter$Factory callAdapter$Factory) {
        this.adapterFactories.add(Utils.checkNotNull(callAdapter$Factory, "factory == null"));
        return this;
    }

    public final Retrofit$Builder callbackExecutor(Executor executor) {
        this.callbackExecutor = Utils.checkNotNull(executor, "executor == null");
        return this;
    }

    public final Retrofit$Builder validateEagerly(boolean bl) {
        this.validateEagerly = bl;
        return this;
    }

    public final Retrofit build() {
        Executor executor;
        if (this.baseUrl == null) {
            throw new IllegalStateException("Base URL required.");
        }
        Call$Factory call$Factory = this.callFactory;
        if (call$Factory == null) {
            call$Factory = new OkHttpClient();
        }
        if ((executor = this.callbackExecutor) == null) {
            executor = this.platform.defaultCallbackExecutor();
        }
        ArrayList<CallAdapter$Factory> arrayList = new ArrayList<CallAdapter$Factory>(this.adapterFactories);
        arrayList.add(this.platform.defaultCallAdapterFactory(executor));
        ArrayList<Converter$Factory> arrayList2 = new ArrayList<Converter$Factory>(this.converterFactories);
        return new Retrofit(call$Factory, this.baseUrl, arrayList2, arrayList, executor, this.validateEagerly);
    }
}

