/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.RequestBuilder$ContentTypeOverridingRequestBody;
import com.zoyi.retrofit2.okhttp3.FormBody$Builder;
import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.HttpUrl$Builder;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.MultipartBody;
import com.zoyi.retrofit2.okhttp3.MultipartBody$Builder;
import com.zoyi.retrofit2.okhttp3.MultipartBody$Part;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Request$Builder;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.retrofit2.okio.Buffer;

final class RequestBuilder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String PATH_SEGMENT_ALWAYS_ENCODE_SET = " \"<>^`{}|\\?#";
    private final String method;
    private final HttpUrl baseUrl;
    private String relativeUrl;
    private HttpUrl$Builder urlBuilder;
    private final Request$Builder requestBuilder;
    private MediaType contentType;
    private final boolean hasBody;
    private MultipartBody$Builder multipartBuilder;
    private FormBody$Builder formBuilder;
    private RequestBody body;

    RequestBuilder(String string, HttpUrl httpUrl, String string2, Headers headers, MediaType mediaType, boolean bl, boolean bl2, boolean bl3) {
        this.method = string;
        this.baseUrl = httpUrl;
        this.relativeUrl = string2;
        this.requestBuilder = new Request$Builder();
        this.contentType = mediaType;
        this.hasBody = bl;
        if (headers != null) {
            this.requestBuilder.headers(headers);
        }
        if (bl2) {
            this.formBuilder = new FormBody$Builder();
            return;
        }
        if (bl3) {
            this.multipartBuilder = new MultipartBody$Builder();
            this.multipartBuilder.setType(MultipartBody.FORM);
        }
    }

    final void setRelativeUrl(Object object) {
        if (object == null) {
            throw new NullPointerException("@Url parameter is null.");
        }
        this.relativeUrl = object.toString();
    }

    final void addHeader(String object, String string) {
        if ("Content-Type".equalsIgnoreCase((String)object)) {
            object = MediaType.parse(string);
            if (object == null) {
                throw new IllegalArgumentException("Malformed content type: " + string);
            }
            this.contentType = object;
            return;
        }
        this.requestBuilder.addHeader((String)object, string);
    }

    final void addPathParam(String string, String string2, boolean bl) {
        if (this.relativeUrl == null) {
            throw new AssertionError();
        }
        this.relativeUrl = this.relativeUrl.replace("{" + string + "}", RequestBuilder.canonicalizeForPath(string2, bl));
    }

    private static String canonicalizeForPath(String string, boolean bl) {
        int n2;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (n2 >= 32 && n2 < 127 && PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(n2) == -1 && (bl || n2 != 47 && n2 != 37)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, 0, i2);
            RequestBuilder.canonicalizeForPath(buffer, string, i2, n3, bl);
            return buffer.readUtf8();
        }
        return string;
    }

    private static void canonicalizeForPath(Buffer buffer, String string, int n2, int n3, boolean bl) {
        Buffer buffer2 = null;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (bl && (n2 == 9 || n2 == 10 || n2 == 12 || n2 == 13)) continue;
            if (n2 < 32 || n2 >= 127 || PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(n2) != -1 || !bl && (n2 == 47 || n2 == 37)) {
                if (buffer2 == null) {
                    buffer2 = new Buffer();
                }
                buffer2.writeUtf8CodePoint(n2);
                while (!buffer2.exhausted()) {
                    int n4 = buffer2.readByte() & 0xFF;
                    buffer.writeByte(37);
                    buffer.writeByte(HEX_DIGITS[n4 >> 4 & 0xF]);
                    buffer.writeByte(HEX_DIGITS[n4 & 0xF]);
                }
                continue;
            }
            buffer.writeUtf8CodePoint(n2);
        }
    }

    final void addQueryParam(String string, String string2, boolean bl) {
        if (this.relativeUrl != null) {
            this.urlBuilder = this.baseUrl.newBuilder(this.relativeUrl);
            if (this.urlBuilder == null) {
                throw new IllegalArgumentException("Malformed URL. Base: " + this.baseUrl + ", Relative: " + this.relativeUrl);
            }
            this.relativeUrl = null;
        }
        if (bl) {
            this.urlBuilder.addEncodedQueryParameter(string, string2);
            return;
        }
        this.urlBuilder.addQueryParameter(string, string2);
    }

    final void addFormField(String string, String string2, boolean bl) {
        if (bl) {
            this.formBuilder.addEncoded(string, string2);
            return;
        }
        this.formBuilder.add(string, string2);
    }

    final void addPart(Headers headers, RequestBody requestBody) {
        this.multipartBuilder.addPart(headers, requestBody);
    }

    final void addPart(MultipartBody$Part multipartBody$Part) {
        this.multipartBuilder.addPart(multipartBody$Part);
    }

    final void setBody(RequestBody requestBody) {
        this.body = requestBody;
    }

    final Request build() {
        MediaType mediaType;
        Object object = this.urlBuilder;
        if (object != null) {
            object = ((HttpUrl$Builder)object).build();
        } else {
            object = this.baseUrl.resolve(this.relativeUrl);
            if (object == null) {
                throw new IllegalArgumentException("Malformed URL. Base: " + this.baseUrl + ", Relative: " + this.relativeUrl);
            }
        }
        RequestBody requestBody = this.body;
        if (requestBody == null) {
            if (this.formBuilder != null) {
                requestBody = this.formBuilder.build();
            } else if (this.multipartBuilder != null) {
                requestBody = this.multipartBuilder.build();
            } else if (this.hasBody) {
                requestBody = RequestBody.create(null, new byte[0]);
            }
        }
        if ((mediaType = this.contentType) != null) {
            if (requestBody != null) {
                requestBody = new RequestBuilder$ContentTypeOverridingRequestBody(requestBody, mediaType);
            } else {
                this.requestBuilder.addHeader("Content-Type", mediaType.toString());
            }
        }
        return this.requestBuilder.url((HttpUrl)object).method(this.method, requestBody).build();
    }
}

