/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okio;

import com.zoyi.io.socket.okio.AsyncTimeout;
import com.zoyi.io.socket.okio.BufferedSink;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.Okio$1;
import com.zoyi.io.socket.okio.Okio$2;
import com.zoyi.io.socket.okio.Okio$3;
import com.zoyi.io.socket.okio.Okio$4;
import com.zoyi.io.socket.okio.RealBufferedSink;
import com.zoyi.io.socket.okio.RealBufferedSource;
import com.zoyi.io.socket.okio.Sink;
import com.zoyi.io.socket.okio.Source;
import com.zoyi.io.socket.okio.Timeout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class Okio {
    static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(OutputStream outputStream, Timeout timeout) {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Okio$1(timeout, outputStream);
    }

    public static Sink sink(Socket closeable) throws IOException {
        if (closeable == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(closeable);
        closeable = Okio.sink(closeable.getOutputStream(), asyncTimeout);
        return asyncTimeout.sink((Sink)closeable);
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(InputStream inputStream, Timeout timeout) {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Okio$2(timeout, inputStream);
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.source(new FileInputStream(file));
    }

    @IgnoreJRERequirement
    public static Source source(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.source(Files.newInputStream(path, openOptionArray));
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file, true));
    }

    @IgnoreJRERequirement
    public static Sink sink(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.sink(Files.newOutputStream(path, openOptionArray));
    }

    public static Sink blackhole() {
        return new Okio$3();
    }

    public static Source source(Socket closeable) throws IOException {
        if (closeable == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(closeable);
        closeable = Okio.source(closeable.getInputStream(), asyncTimeout);
        return asyncTimeout.source((Source)closeable);
    }

    private static AsyncTimeout timeout(Socket socket) {
        return new Okio$4(socket);
    }

    static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }
}

