/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okio;

import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.ForwardingSink;
import com.zoyi.io.socket.okio.Segment;
import com.zoyi.io.socket.okio.Sink;
import com.zoyi.io.socket.okio.Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HashingSink
extends ForwardingSink {
    private final MessageDigest messageDigest;
    private final Mac mac;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    public static HashingSink hmacSha1(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA1");
    }

    public static HashingSink hmacSha256(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA256");
    }

    private HashingSink(Sink sink, String string) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            this.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSink(Sink sink, ByteString byteString, String string) {
        super(sink);
        try {
            this.mac = Mac.getInstance(string);
            this.mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            this.messageDigest = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        int n2;
        Util.checkOffsetAndCount(buffer.size, 0L, l2);
        Segment segment = buffer.head;
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            n2 = (int)Math.min(l2 - i2, (long)(segment.limit - segment.pos));
            if (this.messageDigest != null) {
                this.messageDigest.update(segment.data, segment.pos, n2);
            } else {
                this.mac.update(segment.data, segment.pos, n2);
            }
            segment = segment.next;
        }
        super.write(buffer, l2);
    }

    public final ByteString hash() {
        byte[] byArray = this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(byArray);
    }
}

