/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okio;

import com.zoyi.io.socket.okio.AsyncTimeout$1;
import com.zoyi.io.socket.okio.AsyncTimeout$2;
import com.zoyi.io.socket.okio.AsyncTimeout$Watchdog;
import com.zoyi.io.socket.okio.Sink;
import com.zoyi.io.socket.okio.Source;
import com.zoyi.io.socket.okio.Timeout;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class AsyncTimeout
extends Timeout {
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final long IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    private static AsyncTimeout head;
    private boolean inQueue;
    private AsyncTimeout next;
    private long timeoutAt;

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long l2 = this.timeoutNanos();
        boolean bl = this.hasDeadline();
        if (l2 == 0L && !bl) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout(this, l2, bl);
    }

    private static synchronized void scheduleTimeout(AsyncTimeout asyncTimeout, long l2, boolean bl) {
        if (head == null) {
            head = new AsyncTimeout();
            new AsyncTimeout$Watchdog().start();
        }
        long l3 = System.nanoTime();
        if (l2 != 0L && bl) {
            asyncTimeout.timeoutAt = l3 + Math.min(l2, asyncTimeout.deadlineNanoTime() - l3);
        } else if (l2 != 0L) {
            asyncTimeout.timeoutAt = l3 + l2;
        } else if (bl) {
            asyncTimeout.timeoutAt = asyncTimeout.deadlineNanoTime();
        } else {
            throw new AssertionError();
        }
        long l4 = asyncTimeout.remainingNanos(l3);
        AsyncTimeout asyncTimeout2 = head;
        while (true) {
            if (asyncTimeout2.next == null || l4 < asyncTimeout2.next.remainingNanos(l3)) {
                asyncTimeout.next = asyncTimeout2.next;
                asyncTimeout2.next = asyncTimeout;
                if (asyncTimeout2 != head) break;
                AsyncTimeout.class.notify();
                return;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout asyncTimeout) {
        AsyncTimeout asyncTimeout2 = head;
        while (asyncTimeout2 != null) {
            if (asyncTimeout2.next == asyncTimeout) {
                asyncTimeout2.next = asyncTimeout.next;
                asyncTimeout.next = null;
                return false;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
        return true;
    }

    private long remainingNanos(long l2) {
        return this.timeoutAt - l2;
    }

    protected void timedOut() {
    }

    public final Sink sink(Sink sink) {
        return new AsyncTimeout$1(this, sink);
    }

    public final Source source(Source source) {
        return new AsyncTimeout$2(this, source);
    }

    final void exit(boolean bl) throws IOException {
        boolean bl2 = this.exit();
        if (bl2 && bl) {
            throw this.newTimeoutException(null);
        }
    }

    final IOException exit(IOException iOException) throws IOException {
        if (!this.exit()) {
            return iOException;
        }
        return this.newTimeoutException(iOException);
    }

    protected IOException newTimeoutException(IOException iOException) {
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            interruptedIOException.initCause(iOException);
        }
        return interruptedIOException;
    }

    static AsyncTimeout awaitTimeout() throws InterruptedException {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        if (asyncTimeout == null) {
            long l2 = System.nanoTime();
            AsyncTimeout.class.wait(IDLE_TIMEOUT_MILLIS);
            if (AsyncTimeout.head.next == null && System.nanoTime() - l2 >= IDLE_TIMEOUT_NANOS) {
                return head;
            }
            return null;
        }
        long l3 = asyncTimeout.remainingNanos(System.nanoTime());
        if (l3 > 0L) {
            long l4 = l3 / 1000000L;
            AsyncTimeout.class.wait(l4, (int)(l3 -= l4 * 1000000L));
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    static /* synthetic */ AsyncTimeout access$000() {
        return head;
    }

    static /* synthetic */ AsyncTimeout access$002(AsyncTimeout asyncTimeout) {
        head = asyncTimeout;
        return head;
    }
}

