/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.tls;

import javax.security.auth.x500.X500Principal;

final class DistinguishedNameParser {
    private final String dn;
    private final int length;
    private int pos;
    private int beg;
    private int end;
    private int cur;
    private char[] chars;

    public DistinguishedNameParser(X500Principal x500Principal) {
        this.dn = x500Principal.getName("RFC2253");
        this.length = this.dn.length();
    }

    private String nextAT() {
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos == this.length) {
            return null;
        }
        this.beg = this.pos++;
        while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.chars[this.pos] != '=' || this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
        }
        do {
            ++this.pos;
        } while (this.pos < this.length && this.chars[this.pos] == ' ');
        if (!(this.end - this.beg <= 4 || this.chars[this.beg + 3] != '.' || this.chars[this.beg] != 'O' && this.chars[this.beg] != 'o' || this.chars[this.beg + 1] != 'I' && this.chars[this.beg + 1] != 'i' || this.chars[this.beg + 2] != 'D' && this.chars[this.beg + 2] != 'd')) {
            this.beg += 4;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String quotedAV() {
        ++this.pos;
        this.end = this.beg = this.pos;
        while (true) {
            if (this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
            if (this.chars[this.pos] == '\"') {
                ++this.pos;
                break;
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : this.chars[this.pos];
            ++this.pos;
            ++this.end;
        }
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String hexAV() {
        if (this.pos + 4 >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.beg = this.pos++;
        while (true) {
            if (this.pos == this.length || this.chars[this.pos] == '+' || this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                this.end = this.pos;
                break;
            }
            if (this.chars[this.pos] == ' ') {
                this.end = this.pos++;
                while (this.pos < this.length && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
                break;
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                int n2 = this.pos;
                this.chars[n2] = (char)(this.chars[n2] + 32);
            }
            ++this.pos;
        }
        int n3 = this.end - this.beg;
        if (n3 < 5 || (n3 & 1) == 0) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        byte[] byArray = new byte[n3 / 2];
        int n4 = this.beg + 1;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)this.getByte(n4);
            n4 += 2;
        }
        return new String(this.chars, this.beg, n3);
    }

    private String escapedAV() {
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (this.pos < this.length) {
            switch (this.chars[this.pos]) {
                case '+': 
                case ',': 
                case ';': {
                    return new String(this.chars, this.beg, this.end - this.beg);
                }
                case '\\': {
                    this.chars[this.end++] = this.getEscaped();
                    ++this.pos;
                    continue block5;
                }
                case ' ': {
                    this.cur = this.end;
                    ++this.pos;
                    this.chars[this.end++] = 32;
                    while (this.pos < this.length && this.chars[this.pos] == ' ') {
                        this.chars[this.end++] = 32;
                        ++this.pos;
                    }
                    if (this.pos != this.length && this.chars[this.pos] != ',' && this.chars[this.pos] != '+' && this.chars[this.pos] != ';') continue block5;
                    return new String(this.chars, this.beg, this.cur - this.beg);
                }
            }
            this.chars[this.end++] = this.chars[this.pos];
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private char getEscaped() {
        ++this.pos;
        if (this.pos == this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        switch (this.chars[this.pos]) {
            case ' ': 
            case '\"': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': {
                return this.chars[this.pos];
            }
        }
        return this.getUTF8();
    }

    private char getUTF8() {
        int n2 = this.getByte(this.pos);
        ++this.pos;
        if (n2 < 128) {
            return (char)n2;
        }
        if (n2 >= 192 && n2 <= 247) {
            int n3;
            if (n2 <= 223) {
                n3 = 1;
                n2 &= 0x1F;
            } else if (n2 <= 239) {
                n3 = 2;
                n2 &= 0xF;
            } else {
                n3 = 3;
                n2 &= 7;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                ++this.pos;
                if (this.pos == this.length || this.chars[this.pos] != '\\') {
                    return '?';
                }
                ++this.pos;
                int n4 = this.getByte(this.pos);
                ++this.pos;
                if ((n4 & 0xC0) != 128) {
                    return '?';
                }
                n2 = (n2 << 6) + (n4 & 0x3F);
            }
            return (char)n2;
        }
        return '?';
    }

    private int getByte(int n2) {
        if (n2 + 1 >= this.length) {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        int n3 = this.chars[n2];
        if (n3 >= 48 && n3 <= 57) {
            n3 -= 48;
        } else if (n3 >= 97 && n3 <= 102) {
            n3 -= 87;
        } else if (n3 >= 65 && n3 <= 70) {
            n3 -= 55;
        } else {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        n2 = this.chars[n2 + 1];
        if (n2 >= 48 && n2 <= 57) {
            n2 -= 48;
        } else if (n2 >= 97 && n2 <= 102) {
            n2 -= 87;
        } else if (n2 >= 65 && n2 <= 70) {
            n2 -= 55;
        } else {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        return (n3 << 4) + n2;
    }

    public final String findMostSpecific(String string) {
        this.pos = 0;
        this.beg = 0;
        this.end = 0;
        this.cur = 0;
        this.chars = this.dn.toCharArray();
        String string2 = this.nextAT();
        if (string2 == null) {
            return null;
        }
        do {
            String string3 = "";
            if (this.pos == this.length) {
                return null;
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    string3 = this.quotedAV();
                    break;
                }
                case '#': {
                    string3 = this.hexAV();
                    break;
                }
                case '+': 
                case ',': 
                case ';': {
                    break;
                }
                default: {
                    string3 = this.escapedAV();
                }
            }
            if (string.equalsIgnoreCase(string2)) {
                return string3;
            }
            if (this.pos >= this.length) {
                return null;
            }
            if (this.chars[this.pos] != ',' && this.chars[this.pos] != ';' && this.chars[this.pos] != '+') {
                throw new IllegalStateException("Malformed DN: " + this.dn);
            }
            ++this.pos;
        } while ((string2 = this.nextAT()) != null);
        throw new IllegalStateException("Malformed DN: " + this.dn);
    }
}

