/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.platform;

import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.internal.platform.Platform;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

final class Jdk9Platform
extends Platform {
    final Method setProtocolMethod;
    final Method getProtocolMethod;

    public Jdk9Platform(Method method, Method method2) {
        this.setProtocolMethod = method;
        this.getProtocolMethod = method2;
    }

    @Override
    public final void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> list) {
        try {
            object = sSLSocket.getSSLParameters();
            list = Jdk9Platform.alpnProtocolNames(list);
            this.setProtocolMethod.invoke(object, new Object[]{list.toArray(new String[list.size()])});
            sSLSocket.setSSLParameters((SSLParameters)object);
            return;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError();
        }
    }

    @Override
    public final String getSelectedProtocol(SSLSocket object) {
        try {
            object = (String)this.getProtocolMethod.invoke(object, new Object[0]);
            if (object == null || ((String)object).equals("")) {
                return null;
            }
            return object;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new AssertionError();
        }
    }

    @Override
    public final X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        throw new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on JDK 9+");
    }

    public static Jdk9Platform buildIfSupported() {
        try {
            Method method = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            Method method2 = SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
            return new Jdk9Platform(method, method2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

