/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Header;
import com.zoyi.io.socket.okhttp3.internal.http2.Hpack$Writer;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2;
import com.zoyi.io.socket.okhttp3.internal.http2.Settings;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Writer
implements Closeable {
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    final Hpack$Writer hpackWriter;

    public Http2Writer(BufferedSink bufferedSink, boolean bl) {
        this.sink = bufferedSink;
        this.client = bl;
        this.hpackBuffer = new Buffer();
        this.hpackWriter = new Hpack$Writer(this.hpackBuffer);
        this.maxFrameSize = 16384;
    }

    public final synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format(">> CONNECTION %s", Http2.CONNECTION_PREFACE.hex()));
        }
        this.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
        this.sink.flush();
    }

    public final synchronized void applyAndAckSettings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
        if (settings.getHeaderTableSize() != -1) {
            this.hpackWriter.setHeaderTableSizeSetting(settings.getHeaderTableSize());
        }
        this.frameHeader(0, 0, (byte)4, (byte)1);
        this.sink.flush();
    }

    public final synchronized void pushPromise(int n2, int n3, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(list);
        long l2 = this.hpackBuffer.size();
        int n4 = (int)Math.min((long)(this.maxFrameSize - 4), l2);
        byte by = l2 == (long)n4 ? (byte)4 : 0;
        this.frameHeader(n2, n4 + 4, (byte)5, by);
        this.sink.writeInt(n3 & Integer.MAX_VALUE);
        this.sink.write(this.hpackBuffer, (long)n4);
        if (l2 > (long)n4) {
            this.writeContinuationFrames(n2, l2 - (long)n4);
        }
    }

    public final synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    public final synchronized void synStream(boolean bl, int n2, int n3, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(bl, n2, list);
    }

    public final synchronized void synReply(boolean bl, int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(bl, n2, list);
    }

    public final synchronized void headers(int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(false, n2, list);
    }

    public final synchronized void rstStream(int n2, ErrorCode errorCode) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw new IllegalArgumentException();
        }
        this.frameHeader(n2, 4, (byte)3, (byte)0);
        this.sink.writeInt(errorCode.httpCode);
        this.sink.flush();
    }

    public final int maxDataLength() {
        return this.maxFrameSize;
    }

    public final synchronized void data(boolean bl, int n2, Buffer buffer, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by = 0;
        if (bl) {
            by = 1;
        }
        this.dataFrame(n2, by, buffer, n3);
    }

    final void dataFrame(int n2, byte by, Buffer buffer, int n3) throws IOException {
        this.frameHeader(n2, n3, (byte)0, by);
        if (n3 > 0) {
            this.sink.write(buffer, (long)n3);
        }
    }

    public final synchronized void settings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n2 = settings.size() * 6;
        this.frameHeader(0, n2, (byte)4, (byte)0);
        for (n2 = 0; n2 < 10; ++n2) {
            if (!settings.isSet(n2)) continue;
            int n3 = n2;
            if (n3 == 4) {
                n3 = 3;
            } else if (n3 == 7) {
                n3 = 4;
            }
            this.sink.writeShort(n3);
            this.sink.writeInt(settings.get(n2));
        }
        this.sink.flush();
    }

    public final synchronized void ping(boolean bl, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        bl = bl;
        this.frameHeader(0, 8, (byte)6, bl ? 1 : 0);
        this.sink.writeInt(n2);
        this.sink.writeInt(n3);
        this.sink.flush();
    }

    public final synchronized void goAway(int n2, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
        }
        int n3 = 8 + byArray.length;
        this.frameHeader(0, n3, (byte)7, (byte)0);
        this.sink.writeInt(n2);
        this.sink.writeInt(errorCode.httpCode);
        if (byArray.length > 0) {
            this.sink.write(byArray);
        }
        this.sink.flush();
    }

    public final synchronized void windowUpdate(int n2, long l2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (l2 == 0L || l2 > Integer.MAX_VALUE) {
            throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", l2);
        }
        this.frameHeader(n2, 4, (byte)8, (byte)0);
        this.sink.writeInt((int)l2);
        this.sink.flush();
    }

    public final void frameHeader(int n2, int n3, byte by, byte by2) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, n2, n3, by, by2));
        }
        if (n3 > this.maxFrameSize) {
            throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", this.maxFrameSize, n3);
        }
        if ((n2 & Integer.MIN_VALUE) != 0) {
            throw Http2.illegalArgument("reserved bit set: %s", n2);
        }
        Http2Writer.writeMedium(this.sink, n3);
        this.sink.writeByte(by & 0xFF);
        this.sink.writeByte(by2 & 0xFF);
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private static void writeMedium(BufferedSink bufferedSink, int n2) throws IOException {
        bufferedSink.writeByte(n2 >>> 16 & 0xFF);
        bufferedSink.writeByte(n2 >>> 8 & 0xFF);
        bufferedSink.writeByte(n2 & 0xFF);
    }

    private void writeContinuationFrames(int n2, long l2) throws IOException {
        while (l2 > 0L) {
            int n3;
            this.frameHeader(n2, n3, (byte)9, (l2 -= (long)(n3 = (int)Math.min((long)this.maxFrameSize, l2))) == 0L ? (byte)4 : 0);
            this.sink.write(this.hpackBuffer, (long)n3);
        }
    }

    final void headers(boolean bl, int n2, List<Header> list) throws IOException {
        byte by;
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(list);
        long l2 = this.hpackBuffer.size();
        int n3 = (int)Math.min((long)this.maxFrameSize, l2);
        byte by2 = by = l2 == (long)n3 ? (byte)4 : 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        this.frameHeader(n2, n3, (byte)1, by);
        this.sink.write(this.hpackBuffer, (long)n3);
        if (l2 > (long)n3) {
            this.writeContinuationFrames(n2, l2 - (long)n3);
        }
    }
}

