/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Stream;
import com.zoyi.io.socket.okhttp3.internal.http2.StreamResetException;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.Source;
import com.zoyi.io.socket.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;

final class Http2Stream$FramedDataSource
implements Source {
    private final Buffer receiveBuffer = new Buffer();
    private final Buffer readBuffer = new Buffer();
    private final long maxByteCount;
    boolean closed;
    boolean finished;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ Http2Stream this$0;

    Http2Stream$FramedDataSource(Http2Stream http2Stream, long l2) {
        this.this$0 = http2Stream;
        this.maxByteCount = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        long l3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        Object object = this.this$0;
        synchronized (object) {
            this.waitUntilReadable();
            this.checkNotClosed();
            if (this.readBuffer.size() == 0L) {
                return -1L;
            }
            l3 = this.readBuffer.read(buffer, Math.min(l2, this.readBuffer.size()));
            this.this$0.unacknowledgedBytesRead += l3;
            if (this.this$0.unacknowledgedBytesRead >= (long)(this.this$0.connection.okHttpSettings.getInitialWindowSize() / 2)) {
                this.this$0.connection.writeWindowUpdateLater(this.this$0.id, this.this$0.unacknowledgedBytesRead);
                this.this$0.unacknowledgedBytesRead = 0L;
            }
        }
        object = this.this$0.connection;
        synchronized (object) {
            this.this$0.connection.unacknowledgedBytesRead += l3;
            if (this.this$0.connection.unacknowledgedBytesRead >= (long)(this.this$0.connection.okHttpSettings.getInitialWindowSize() / 2)) {
                this.this$0.connection.writeWindowUpdateLater(0, this.this$0.connection.unacknowledgedBytesRead);
                this.this$0.connection.unacknowledgedBytesRead = 0L;
            }
        }
        return l3;
    }

    private void waitUntilReadable() throws IOException {
        this.this$0.readTimeout.enter();
        try {
            while (this.readBuffer.size() == 0L && !this.finished && !this.closed && this.this$0.errorCode == null) {
                this.this$0.waitForIo();
            }
            return;
        }
        finally {
            this.this$0.readTimeout.exitAndThrowIfTimedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receive(BufferedSource bufferedSource, long l2) throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this.this$0)) {
            throw new AssertionError();
        }
        while (l2 > 0L) {
            boolean bl;
            boolean bl2;
            Http2Stream http2Stream = this.this$0;
            synchronized (http2Stream) {
                bl2 = this.finished;
                bl = l2 + this.readBuffer.size() > this.maxByteCount;
            }
            if (bl) {
                bufferedSource.skip(l2);
                this.this$0.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                return;
            }
            if (bl2) {
                bufferedSource.skip(l2);
                return;
            }
            long l3 = bufferedSource.read(this.receiveBuffer, l2);
            if (l3 == -1L) {
                throw new EOFException();
            }
            l2 -= l3;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream2) {
                bl = this.readBuffer.size() == 0L;
                this.readBuffer.writeAll(this.receiveBuffer);
                if (bl) {
                    this.this$0.notifyAll();
                }
            }
        }
    }

    @Override
    public final Timeout timeout() {
        return this.this$0.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Http2Stream http2Stream = this.this$0;
        synchronized (http2Stream) {
            this.closed = true;
            this.readBuffer.clear();
            this.this$0.notifyAll();
        }
        this.this$0.cancelStreamIfNecessary();
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (this.this$0.errorCode != null) {
            throw new StreamResetException(this.this$0.errorCode);
        }
    }

    static {
        $assertionsDisabled = !Http2Stream.class.desiredAssertionStatus();
    }
}

