/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Header;
import com.zoyi.io.socket.okhttp3.internal.http2.Hpack$Reader;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Reader$ContinuationSource;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Reader$Handler;
import com.zoyi.io.socket.okhttp3.internal.http2.Settings;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Reader
implements Closeable {
    static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSource source;
    private final Http2Reader$ContinuationSource continuation;
    private final boolean client;
    final Hpack$Reader hpackReader;

    public Http2Reader(BufferedSource bufferedSource, boolean bl) {
        this.source = bufferedSource;
        this.client = bl;
        this.continuation = new Http2Reader$ContinuationSource(this.source);
        this.hpackReader = new Hpack$Reader(4096, this.continuation);
    }

    public final void readConnectionPreface() throws IOException {
        if (this.client) {
            return;
        }
        ByteString byteString = this.source.readByteString(Http2.CONNECTION_PREFACE.size());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format("<< CONNECTION %s", byteString.hex()));
        }
        if (!Http2.CONNECTION_PREFACE.equals(byteString)) {
            throw Http2.ioException("Expected a connection header but was %s", byteString.utf8());
        }
    }

    public final boolean nextFrame(Http2Reader$Handler http2Reader$Handler) throws IOException {
        try {
            this.source.require(9L);
        }
        catch (IOException iOException) {
            return false;
        }
        int n2 = Http2Reader.readMedium(this.source);
        if (n2 < 0 || n2 > 16384) {
            throw Http2.ioException("FRAME_SIZE_ERROR: %s", n2);
        }
        byte by = this.source.readByte();
        byte by2 = this.source.readByte();
        int n3 = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(true, n3, n2, by, by2));
        }
        switch (by) {
            case 0: {
                this.readData(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 1: {
                this.readHeaders(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 2: {
                this.readPriority(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 3: {
                this.readRstStream(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 4: {
                this.readSettings(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 5: {
                this.readPushPromise(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 6: {
                this.readPing(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 7: {
                this.readGoAway(http2Reader$Handler, n2, by2, n3);
                break;
            }
            case 8: {
                this.readWindowUpdate(http2Reader$Handler, n2, by2, n3);
                break;
            }
            default: {
                this.source.skip(n2);
            }
        }
        return true;
    }

    private void readHeaders(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        short s2;
        if (n3 == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
        }
        boolean bl = (by & 1) != 0;
        short s3 = s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        if ((by & 0x20) != 0) {
            this.readPriority(http2Reader$Handler, n3);
            n2 -= 5;
        }
        n2 = Http2Reader.lengthWithoutPadding(n2, by, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by, n3);
        http2Reader$Handler.headers(bl, n3, -1, list);
    }

    private List<Header> readHeaderBlock(int n2, short s2, byte by, int n3) throws IOException {
        this.continuation.length = this.continuation.left = n2;
        this.continuation.padding = s2;
        this.continuation.flags = by;
        this.continuation.streamId = n3;
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private void readData(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        boolean bl = (by & 1) != 0;
        short s2 = (by & 0x20) != 0 ? (short)1 : 0;
        if (s2 != 0) {
            throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
        }
        s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        n2 = Http2Reader.lengthWithoutPadding(n2, by, s2);
        http2Reader$Handler.data(bl, n3, this.source, n2);
        this.source.skip(s2);
    }

    private void readPriority(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 5) {
            throw Http2.ioException("TYPE_PRIORITY length: %d != 5", n2);
        }
        if (n3 == 0) {
            throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
        }
        this.readPriority(http2Reader$Handler, n3);
    }

    private void readPriority(Http2Reader$Handler http2Reader$Handler, int n2) throws IOException {
        int n3 = this.source.readInt();
        boolean bl = (n3 & Integer.MIN_VALUE) != 0;
        int n4 = (this.source.readByte() & 0xFF) + 1;
        http2Reader$Handler.priority(n2, n3 &= Integer.MAX_VALUE, n4, bl);
    }

    private void readRstStream(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", n2);
        }
        if (n3 == 0) {
            throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
        }
        n2 = this.source.readInt();
        ErrorCode errorCode = ErrorCode.fromHttp2(n2);
        if (errorCode == null) {
            throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", n2);
        }
        http2Reader$Handler.rstStream(n3, errorCode);
    }

    private void readSettings(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        if (n3 != 0) {
            throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
        }
        if ((by & 1) != 0) {
            if (n2 != 0) {
                throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
            }
            http2Reader$Handler.ackSettings();
            return;
        }
        if (n2 % 6 != 0) {
            throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", n2);
        }
        Settings settings = new Settings();
        for (n3 = 0; n3 < n2; n3 += 6) {
            int n4 = this.source.readShort();
            int n5 = this.source.readInt();
            switch (n4) {
                case 1: {
                    break;
                }
                case 2: {
                    if (n5 == 0 || n5 == 1) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                }
                case 3: {
                    n4 = 4;
                    break;
                }
                case 4: {
                    n4 = 7;
                    if (n5 >= 0) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                }
                case 5: {
                    if (n5 >= 16384 && n5 <= 0xFFFFFF) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", n5);
                }
            }
            settings.set(n4, n5);
        }
        http2Reader$Handler.settings(false, settings);
    }

    private void readPushPromise(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        if (n3 == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
        }
        short s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        int n4 = this.source.readInt() & Integer.MAX_VALUE;
        n2 -= 4;
        n2 = Http2Reader.lengthWithoutPadding(n2, by, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by, n3);
        http2Reader$Handler.pushPromise(n3, n4, list);
    }

    private void readPing(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 8) {
            throw Http2.ioException("TYPE_PING length != 8: %s", n2);
        }
        if (n3 != 0) {
            throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
        }
        n2 = this.source.readInt();
        n3 = this.source.readInt();
        by = (by & 1) != 0 ? (byte)1 : 0;
        http2Reader$Handler.ping(by != 0, n2, n3);
    }

    private void readGoAway(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 < 8) {
            throw Http2.ioException("TYPE_GOAWAY length < 8: %s", n2);
        }
        if (n3 != 0) {
            throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
        }
        by = (byte)this.source.readInt();
        n3 = this.source.readInt();
        n2 -= 8;
        ErrorCode errorCode = ErrorCode.fromHttp2(n3);
        if (errorCode == null) {
            throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", n3);
        }
        ByteString byteString = ByteString.EMPTY;
        if (n2 > 0) {
            byteString = this.source.readByteString(n2);
        }
        http2Reader$Handler.goAway(by, errorCode, byteString);
    }

    private void readWindowUpdate(Http2Reader$Handler http2Reader$Handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", n2);
        }
        long l2 = (long)this.source.readInt() & Integer.MAX_VALUE;
        if (l2 == 0L) {
            throw Http2.ioException("windowSizeIncrement was 0", l2);
        }
        http2Reader$Handler.windowUpdate(n3, l2);
    }

    @Override
    public final void close() throws IOException {
        this.source.close();
    }

    static int readMedium(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    static int lengthWithoutPadding(int n2, byte by, short s2) throws IOException {
        if ((by & 8) != 0) {
            --n2;
        }
        if (s2 > n2) {
            throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", s2, n2);
        }
        return (short)(n2 - s2);
    }
}

