/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.http2.ConnectionShutdownException;
import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Header;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$1;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$2;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$3;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$4;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$5;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$6;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$7;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$Builder;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$Listener;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection$ReaderRunnable;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Reader;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Stream;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Writer;
import com.zoyi.io.socket.okhttp3.internal.http2.Ping;
import com.zoyi.io.socket.okhttp3.internal.http2.PushObserver;
import com.zoyi.io.socket.okhttp3.internal.http2.Settings;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Http2Connection
implements Closeable {
    static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp FramedConnection", true));
    final boolean client;
    final Http2Connection$Listener listener;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    final String hostname;
    int lastGoodStreamId;
    int nextStreamId;
    boolean shutdown;
    private final ExecutorService pushExecutor;
    private Map<Integer, Ping> pings;
    final PushObserver pushObserver;
    private int nextPingId;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    final Settings peerSettings = new Settings();
    boolean receivedInitialPeerSettings = false;
    final Socket socket;
    final Http2Writer writer;
    final Http2Connection$ReaderRunnable readerRunnable;
    final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    Http2Connection(Http2Connection$Builder http2Connection$Builder) {
        this.pushObserver = http2Connection$Builder.pushObserver;
        this.client = http2Connection$Builder.client;
        this.listener = http2Connection$Builder.listener;
        int n2 = this.nextStreamId = http2Connection$Builder.client ? 1 : 2;
        if (http2Connection$Builder.client) {
            this.nextStreamId += 2;
        }
        int n3 = this.nextPingId = http2Connection$Builder.client ? 1 : 2;
        if (http2Connection$Builder.client) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        this.hostname = http2Connection$Builder.hostname;
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.hostname), true));
        this.peerSettings.set(7, 65535);
        this.peerSettings.set(5, 16384);
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize();
        this.socket = http2Connection$Builder.socket;
        this.writer = new Http2Writer(http2Connection$Builder.sink, this.client);
        this.readerRunnable = new Http2Connection$ReaderRunnable(this, new Http2Reader(http2Connection$Builder.source, this.client));
    }

    public final Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    final synchronized Http2Stream getStream(int n2) {
        return this.streams.get(n2);
    }

    final synchronized Http2Stream removeStream(int n2) {
        Http2Stream http2Stream = this.streams.remove(n2);
        this.notifyAll();
        return http2Stream;
    }

    public final synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    public final Http2Stream pushStream(int n2, List<Header> list, boolean bl) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        return this.newStream(n2, list, bl);
    }

    public final Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.newStream(0, list, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Stream newStream(int n2, List<Header> list, boolean bl) throws IOException {
        Http2Stream http2Stream;
        boolean bl2 = !bl;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                n3 = this.nextStreamId;
                this.nextStreamId += 2;
                http2Stream = new Http2Stream(n3, this, bl2, false, list);
                boolean bl3 = bl = !bl || this.bytesLeftInWriteWindow == 0L || http2Stream.bytesLeftInWriteWindow == 0L;
                if (http2Stream.isOpen()) {
                    this.streams.put(n3, http2Stream);
                }
            }
            if (n2 == 0) {
                this.writer.synStream(bl2, n3, n2, list);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.writer.pushPromise(n2, n3, list);
            }
        }
        if (bl) {
            this.writer.flush();
        }
        return http2Stream;
    }

    final void writeSynReply(int n2, boolean bl, List<Header> list) throws IOException {
        this.writer.synReply(bl, n2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int n2, boolean bl, Buffer buffer, long l2) throws IOException {
        if (l2 == 0L) {
            this.writer.data(bl, n2, buffer, 0);
            return;
        }
        while (l2 > 0L) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(n2)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                n3 = (int)Math.min(l2, this.bytesLeftInWriteWindow);
                n3 = Math.min(n3, this.writer.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)n3;
            }
            this.writer.data(bl && (l2 -= (long)n3) == 0L, n2, buffer, n3);
        }
    }

    final void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    final void writeSynResetLater(int n2, ErrorCode errorCode) {
        executor.execute(new Http2Connection$1(this, "OkHttp %s stream %d", new Object[]{this.hostname, n2}, n2, errorCode));
    }

    final void writeSynReset(int n2, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n2, errorCode);
    }

    final void writeWindowUpdateLater(int n2, long l2) {
        executor.execute(new Http2Connection$2(this, "OkHttp Window Update %s stream %d", new Object[]{this.hostname, n2}, n2, l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Ping ping() throws IOException {
        int n2;
        Ping ping = new Ping();
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.shutdown) {
                throw new ConnectionShutdownException();
            }
            n2 = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new LinkedHashMap<Integer, Ping>();
            }
            this.pings.put(n2, ping);
        }
        this.writePing(false, n2, 1330343787, ping);
        return ping;
    }

    final void writePingLater(boolean bl, int n2, int n3, Ping ping) {
        executor.execute(new Http2Connection$3(this, "OkHttp %s ping %08x%08x", new Object[]{this.hostname, n2, n3}, bl, n2, n3, ping));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writePing(boolean bl, int n2, int n3, Ping ping) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            if (ping != null) {
                ping.send();
            }
            this.writer.ping(bl, n2, n3);
            return;
        }
    }

    final synchronized Ping removePing(int n2) {
        if (this.pings != null) {
            return this.pings.remove(n2);
        }
        return null;
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n2 = this.lastGoodStreamId;
            }
            this.writer.goAway(n2, errorCode, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close(ErrorCode http2StreamArray, ErrorCode errorCode) throws IOException {
        IOException iOException;
        block19: {
            int n2;
            assert (!Thread.holdsLock(this));
            iOException = null;
            try {
                this.shutdown((ErrorCode)((Object)http2StreamArray));
            }
            catch (IOException iOException2) {
                http2StreamArray = iOException2;
                iOException = iOException2;
            }
            http2StreamArray = null;
            Ping[] pingArray = null;
            Http2Connection object = this;
            synchronized (object) {
                if (!this.streams.isEmpty()) {
                    http2StreamArray = this.streams.values().toArray(new Http2Stream[this.streams.size()]);
                    this.streams.clear();
                }
                if (this.pings != null) {
                    pingArray = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
            }
            if (http2StreamArray != null) {
                Object iOException4 = http2StreamArray;
                int n3 = ((Http2Stream[])http2StreamArray).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Http2Stream http2Stream = iOException4[n2];
                    try {
                        http2Stream.close(errorCode);
                        continue;
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) continue;
                        iOException = iOException3;
                    }
                }
            }
            if (pingArray != null) {
                Ping[] pingArray2 = pingArray;
                int n22 = pingArray.length;
                for (n2 = 0; n2 < n22; ++n2) {
                    Ping ping = pingArray2[n2];
                    ping.cancel();
                }
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException4) {
                if (iOException != null) break block19;
                iOException = iOException4;
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException5) {
            IOException iOException6 = iOException5;
            iOException = iOException5;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public final void start() throws IOException {
        this.start(true);
    }

    final void start(boolean n2) throws IOException {
        if (n2) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            n2 = this.okHttpSettings.getInitialWindowSize();
            if (n2 != 65535) {
                this.writer.windowUpdate(0, n2 - 65535);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(Settings settings) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
                this.writer.settings(settings);
            }
            return;
        }
    }

    public final synchronized boolean isShutdown() {
        return this.shutdown;
    }

    final boolean pushedStream(int n2) {
        return n2 != 0 && (n2 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void pushRequestLater(int n2, List<Header> list) {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.currentPushRequests.contains(n2)) {
                this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n2);
        }
        this.pushExecutor.execute(new Http2Connection$4(this, "OkHttp %s Push Request[%s]", new Object[]{this.hostname, n2}, n2, list));
    }

    final void pushHeadersLater(int n2, List<Header> list, boolean bl) {
        this.pushExecutor.execute(new Http2Connection$5(this, "OkHttp %s Push Headers[%s]", new Object[]{this.hostname, n2}, n2, list, bl));
    }

    final void pushDataLater(int n2, BufferedSource bufferedSource, int n3, boolean bl) throws IOException {
        Buffer buffer = new Buffer();
        bufferedSource.require(n3);
        bufferedSource.read(buffer, n3);
        if (buffer.size() != (long)n3) {
            throw new IOException(buffer.size() + " != " + n3);
        }
        this.pushExecutor.execute(new Http2Connection$6(this, "OkHttp %s Push Data[%s]", new Object[]{this.hostname, n2}, n2, buffer, n3, bl));
    }

    final void pushResetLater(int n2, ErrorCode errorCode) {
        this.pushExecutor.execute(new Http2Connection$7(this, "OkHttp %s Push Reset[%s]", new Object[]{this.hostname, n2}, n2, errorCode));
    }
}

