/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Headers$Builder;
import com.zoyi.io.socket.okhttp3.OkHttpClient;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.Response$Builder;
import com.zoyi.io.socket.okhttp3.ResponseBody;
import com.zoyi.io.socket.okhttp3.internal.Internal;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.connection.StreamAllocation;
import com.zoyi.io.socket.okhttp3.internal.http.HttpCodec;
import com.zoyi.io.socket.okhttp3.internal.http.RealResponseBody;
import com.zoyi.io.socket.okhttp3.internal.http.RequestLine;
import com.zoyi.io.socket.okhttp3.internal.http.StatusLine;
import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Header;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Codec$StreamFinishingSource;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Stream;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.Okio;
import com.zoyi.io.socket.okio.Sink;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2Codec
implements HttpCodec {
    private static final ByteString CONNECTION = ByteString.encodeUtf8("connection");
    private static final ByteString HOST = ByteString.encodeUtf8("host");
    private static final ByteString KEEP_ALIVE = ByteString.encodeUtf8("keep-alive");
    private static final ByteString PROXY_CONNECTION = ByteString.encodeUtf8("proxy-connection");
    private static final ByteString TRANSFER_ENCODING = ByteString.encodeUtf8("transfer-encoding");
    private static final ByteString TE = ByteString.encodeUtf8("te");
    private static final ByteString ENCODING = ByteString.encodeUtf8("encoding");
    private static final ByteString UPGRADE = ByteString.encodeUtf8("upgrade");
    private static final List<ByteString> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY);
    private static final List<ByteString> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    private final OkHttpClient client;
    final StreamAllocation streamAllocation;
    private final Http2Connection connection;
    private Http2Stream stream;

    public Http2Codec(OkHttpClient okHttpClient, StreamAllocation streamAllocation, Http2Connection http2Connection) {
        this.client = okHttpClient;
        this.streamAllocation = streamAllocation;
        this.connection = http2Connection;
    }

    @Override
    public final Sink createRequestBody(Request request, long l2) {
        return this.stream.getSink();
    }

    @Override
    public final void writeRequestHeaders(Request object) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean bl = ((Request)object).body() != null;
        object = Http2Codec.http2HeadersList((Request)object);
        this.stream = this.connection.newStream((List<Header>)object, bl);
        this.stream.readTimeout().timeout(this.client.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public final Response$Builder readResponseHeaders() throws IOException {
        return Http2Codec.readHttp2HeadersList(this.stream.getResponseHeaders());
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, request.method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        arrayList.add(new Header(Header.TARGET_AUTHORITY, Util.hostHeader(request.url(), false)));
        arrayList.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = ByteString.encodeUtf8(headers.name(i2).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(byteString)) continue;
            arrayList.add(new Header(byteString, headers.value(i2)));
        }
        return arrayList;
    }

    public static Response$Builder readHttp2HeadersList(List<Header> list) throws IOException {
        String string = null;
        Headers$Builder headers$Builder = new Headers$Builder();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = list.get((int)i2).name;
            String string2 = list.get((int)i2).value.utf8();
            if (byteString.equals(Header.RESPONSE_STATUS)) {
                string = string2;
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(byteString)) continue;
            Internal.instance.addLenient(headers$Builder, byteString.utf8(), string2);
        }
        if (string == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        StatusLine statusLine = StatusLine.parse("HTTP/1.1 " + string);
        return new Response$Builder().protocol(Protocol.HTTP_2).code(statusLine.code).message(statusLine.message).headers(headers$Builder.build());
    }

    @Override
    public final ResponseBody openResponseBody(Response response) throws IOException {
        Http2Codec$StreamFinishingSource http2Codec$StreamFinishingSource = new Http2Codec$StreamFinishingSource(this, this.stream.getSource());
        return new RealResponseBody(response.headers(), Okio.buffer(http2Codec$StreamFinishingSource));
    }

    @Override
    public final void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }
}

