/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.internal.http2.Header;
import com.zoyi.io.socket.okhttp3.internal.http2.Hpack;
import com.zoyi.io.socket.okhttp3.internal.http2.Huffman;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.Okio;
import com.zoyi.io.socket.okio.Source;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class Hpack$Reader {
    private final List<Header> headerList = new ArrayList<Header>();
    private final BufferedSource source;
    private final int headerTableSizeSetting;
    private int maxDynamicTableByteCount;
    Header[] dynamicTable = new Header[8];
    int nextHeaderIndex = this.dynamicTable.length - 1;
    int headerCount = 0;
    int dynamicTableByteCount = 0;

    Hpack$Reader(int n2, Source source) {
        this(n2, n2, source);
    }

    Hpack$Reader(int n2, int n3, Source source) {
        this.headerTableSizeSetting = n2;
        this.maxDynamicTableByteCount = n3;
        this.source = Okio.buffer(source);
    }

    final int maxDynamicTableByteCount() {
        return this.maxDynamicTableByteCount;
    }

    private void adjustDynamicTableByteCount() {
        if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
            if (this.maxDynamicTableByteCount == 0) {
                this.clearDynamicTable();
                return;
            }
            this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
        }
    }

    private void clearDynamicTable() {
        Arrays.fill(this.dynamicTable, null);
        this.nextHeaderIndex = this.dynamicTable.length - 1;
        this.headerCount = 0;
        this.dynamicTableByteCount = 0;
    }

    private int evictToRecoverBytes(int n2) {
        int n3 = 0;
        if (n2 > 0) {
            for (int i2 = this.dynamicTable.length - 1; i2 >= this.nextHeaderIndex && n2 > 0; --i2) {
                n2 -= this.dynamicTable[i2].hpackSize;
                this.dynamicTableByteCount -= this.dynamicTable[i2].hpackSize;
                --this.headerCount;
                ++n3;
            }
            System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
            this.nextHeaderIndex += n3;
        }
        return n3;
    }

    final void readHeaders() throws IOException {
        while (!this.source.exhausted()) {
            int n2 = this.source.readByte() & 0xFF;
            if (n2 == 128) {
                throw new IOException("index == 0");
            }
            if ((n2 & 0x80) == 128) {
                n2 = this.readInt(n2, 127);
                this.readIndexedHeader(n2 - 1);
                continue;
            }
            if (n2 == 64) {
                this.readLiteralHeaderWithIncrementalIndexingNewName();
                continue;
            }
            if ((n2 & 0x40) == 64) {
                n2 = this.readInt(n2, 63);
                this.readLiteralHeaderWithIncrementalIndexingIndexedName(n2 - 1);
                continue;
            }
            if ((n2 & 0x20) == 32) {
                this.maxDynamicTableByteCount = this.readInt(n2, 31);
                if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                    throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                }
                this.adjustDynamicTableByteCount();
                continue;
            }
            if (n2 == 16 || n2 == 0) {
                this.readLiteralHeaderWithoutIndexingNewName();
                continue;
            }
            n2 = this.readInt(n2, 15);
            this.readLiteralHeaderWithoutIndexingIndexedName(n2 - 1);
        }
    }

    public final List<Header> getAndResetHeaderList() {
        ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
        this.headerList.clear();
        return arrayList;
    }

    private void readIndexedHeader(int n2) throws IOException {
        if (this.isStaticHeader(n2)) {
            Header header = Hpack.STATIC_HEADER_TABLE[n2];
            this.headerList.add(header);
            return;
        }
        int n3 = this.dynamicTableIndex(n2 - Hpack.STATIC_HEADER_TABLE.length);
        if (n3 < 0 || n3 > this.dynamicTable.length - 1) {
            throw new IOException("Header index too large " + (n2 + 1));
        }
        this.headerList.add(this.dynamicTable[n3]);
    }

    private int dynamicTableIndex(int n2) {
        return this.nextHeaderIndex + 1 + n2;
    }

    private void readLiteralHeaderWithoutIndexingIndexedName(int n2) throws IOException {
        ByteString byteString = this.getName(n2);
        ByteString byteString2 = this.readByteString();
        this.headerList.add(new Header(byteString, byteString2));
    }

    private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
        ByteString byteString = Hpack.checkLowercase(this.readByteString());
        ByteString byteString2 = this.readByteString();
        this.headerList.add(new Header(byteString, byteString2));
    }

    private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n2) throws IOException {
        ByteString byteString = this.getName(n2);
        ByteString byteString2 = this.readByteString();
        this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
    }

    private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
        ByteString byteString = Hpack.checkLowercase(this.readByteString());
        ByteString byteString2 = this.readByteString();
        this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
    }

    private ByteString getName(int n2) {
        if (this.isStaticHeader(n2)) {
            return Hpack.STATIC_HEADER_TABLE[n2].name;
        }
        return this.dynamicTable[this.dynamicTableIndex((int)(n2 - Hpack.STATIC_HEADER_TABLE.length))].name;
    }

    private boolean isStaticHeader(int n2) {
        return n2 >= 0 && n2 <= Hpack.STATIC_HEADER_TABLE.length - 1;
    }

    private void insertIntoDynamicTable(int n2, Header header) {
        this.headerList.add(header);
        int n3 = header.hpackSize;
        if (n2 != -1) {
            n3 -= this.dynamicTable[this.dynamicTableIndex((int)n2)].hpackSize;
        }
        if (n3 > this.maxDynamicTableByteCount) {
            this.clearDynamicTable();
            return;
        }
        int n4 = this.dynamicTableByteCount + n3 - this.maxDynamicTableByteCount;
        n4 = this.evictToRecoverBytes(n4);
        if (n2 == -1) {
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray = new Header[this.dynamicTable.length << 1];
                System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            n2 = this.nextHeaderIndex--;
            this.dynamicTable[n2] = header;
            ++this.headerCount;
        } else {
            n2 += this.dynamicTableIndex(n2) + n4;
            this.dynamicTable[n2] = header;
        }
        this.dynamicTableByteCount += n3;
    }

    private int readByte() throws IOException {
        return this.source.readByte() & 0xFF;
    }

    final int readInt(int n2, int n3) throws IOException {
        int n4;
        if ((n2 &= n3) < n3) {
            return n2;
        }
        n2 = n3;
        n3 = 0;
        while (((n4 = this.readByte()) & 0x80) != 0) {
            n2 += (n4 & 0x7F) << n3;
            n3 += 7;
        }
        return n2 += n4 << n3;
    }

    final ByteString readByteString() throws IOException {
        int n2 = this.readByte();
        boolean bl = (n2 & 0x80) == 128;
        n2 = this.readInt(n2, 127);
        if (bl) {
            return ByteString.of(Huffman.get().decode(this.source.readByteArray(n2)));
        }
        return this.source.readByteString(n2);
    }
}

