/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http;

import com.zoyi.io.socket.okhttp3.Challenge;
import com.zoyi.io.socket.okhttp3.Cookie;
import com.zoyi.io.socket.okhttp3.CookieJar;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Headers$Builder;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpHeaders {
    private static final String TOKEN = "([^ \"=]*)";
    private static final String QUOTED_STRING = "\"([^\"]*)\"";
    private static final Pattern PARAMETER = Pattern.compile(" +([^ \"=]*)=(:?\"([^\"]*)\"|([^ \"=]*)) *(:?,|$)");

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response object, Headers headers, Request request) {
        for (String string : HttpHeaders.varyFields((Response)object)) {
            if (Util.equal(headers.values(string), request.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return HttpHeaders.varyFields(headers).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!"Vary".equalsIgnoreCase(headers.name(i2))) continue;
            String[] stringArray = headers.value(i2);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string : stringArray.split(",")) {
                set.add(string.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response object) {
        Headers headers = ((Response)object).networkResponse().request().headers();
        object = ((Response)object).headers();
        return HttpHeaders.varyHeaders(headers, (Headers)object);
    }

    public static Headers varyHeaders(Headers headers, Headers object) {
        if ((object = HttpHeaders.varyFields((Headers)object)).isEmpty()) {
            return new Headers$Builder().build();
        }
        Headers$Builder headers$Builder = new Headers$Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = headers.name(i2);
            if (!object.contains(string)) continue;
            headers$Builder.add(string, headers.value(i2));
        }
        return headers$Builder.build();
    }

    public static List<Challenge> parseChallenges(Headers iterator, String string) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        iterator = ((Headers)((Object)iterator)).values(string);
        iterator = iterator.iterator();
        block0: while (iterator.hasNext()) {
            string = iterator.next();
            int n2 = string.indexOf(32);
            if (n2 == -1) continue;
            Matcher matcher = PARAMETER.matcher(string);
            int n3 = n2;
            while (matcher.find(n3)) {
                if (string.regionMatches(true, matcher.start(1), "realm", 0, 5)) {
                    String string2 = string.substring(0, n2);
                    String string3 = matcher.group(3);
                    if (string3 != null) {
                        arrayList.add(new Challenge(string2, string3));
                        continue block0;
                    }
                }
                n3 = matcher.end();
            }
        }
        return arrayList;
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers object) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        if ((object = Cookie.parseAll(httpUrl, (Headers)object)).isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, (List<Cookie>)object);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n2 = response.code();
        if ((n2 < 100 || n2 >= 200) && n2 != 204 && n2 != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    public static int skipUntil(String string, int n2, String string2) {
        while (n2 < string.length() && string2.indexOf(string.charAt(n2)) == -1) {
            ++n2;
        }
        return n2;
    }

    public static int skipWhitespace(String string, int n2) {
        char c2;
        while (n2 < string.length() && ((c2 = string.charAt(n2)) == ' ' || c2 == '\t')) {
            ++n2;
        }
        return n2;
    }

    public static int parseSeconds(String string, int n2) {
        long l2;
        block3: {
            try {
                l2 = Long.parseLong(string);
                if (l2 > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (l2 >= 0L) break block3;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return (int)l2;
    }
}

