/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http;

import com.zoyi.io.socket.okhttp3.Cookie;
import com.zoyi.io.socket.okhttp3.CookieJar;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Interceptor;
import com.zoyi.io.socket.okhttp3.Interceptor$Chain;
import com.zoyi.io.socket.okhttp3.MediaType;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Request$Builder;
import com.zoyi.io.socket.okhttp3.RequestBody;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.Response$Builder;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.Version;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import com.zoyi.io.socket.okhttp3.internal.http.RealResponseBody;
import com.zoyi.io.socket.okio.GzipSource;
import com.zoyi.io.socket.okio.Okio;
import com.zoyi.io.socket.okio.Source;
import java.io.IOException;
import java.util.List;

public final class BridgeInterceptor
implements Interceptor {
    private final CookieJar cookieJar;

    public BridgeInterceptor(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
    }

    @Override
    public final Response intercept(Interceptor$Chain object) throws IOException {
        List<Cookie> list;
        Object object2 = object.request();
        Object object3 = ((Request)object2).newBuilder();
        RequestBody requestBody = ((Request)object2).body();
        if (requestBody != null) {
            long l2;
            MediaType mediaType = requestBody.contentType();
            if (mediaType != null) {
                ((Request$Builder)object3).header("Content-Type", mediaType.toString());
            }
            if ((l2 = requestBody.contentLength()) != -1L) {
                ((Request$Builder)object3).header("Content-Length", Long.toString(l2));
                ((Request$Builder)object3).removeHeader("Transfer-Encoding");
            } else {
                ((Request$Builder)object3).header("Transfer-Encoding", "chunked");
                ((Request$Builder)object3).removeHeader("Content-Length");
            }
        }
        if (((Request)object2).header("Host") == null) {
            ((Request$Builder)object3).header("Host", Util.hostHeader(((Request)object2).url(), false));
        }
        if (((Request)object2).header("Connection") == null) {
            ((Request$Builder)object3).header("Connection", "Keep-Alive");
        }
        boolean bl = false;
        if (((Request)object2).header("Accept-Encoding") == null) {
            bl = true;
            ((Request$Builder)object3).header("Accept-Encoding", "gzip");
        }
        if (!(list = this.cookieJar.loadForRequest(((Request)object2).url())).isEmpty()) {
            ((Request$Builder)object3).header("Cookie", this.cookieHeader(list));
        }
        if (((Request)object2).header("User-Agent") == null) {
            ((Request$Builder)object3).header("User-Agent", Version.userAgent());
        }
        Response response = object.proceed(((Request$Builder)object3).build());
        HttpHeaders.receiveHeaders(this.cookieJar, ((Request)object2).url(), response.headers());
        object = response.newBuilder().request((Request)object2);
        if (bl && "gzip".equalsIgnoreCase(response.header("Content-Encoding")) && HttpHeaders.hasBody(response)) {
            object2 = new GzipSource(response.body().source());
            object3 = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            ((Response$Builder)object).headers((Headers)object3);
            ((Response$Builder)object).body(new RealResponseBody((Headers)object3, Okio.buffer((Source)object2)));
        }
        return ((Response$Builder)object).build();
    }

    private String cookieHeader(List<Cookie> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append("; ");
            }
            Cookie cookie = list.get(i2);
            stringBuilder.append(cookie.name()).append('=').append(cookie.value());
        }
        return stringBuilder.toString();
    }
}

