/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.connection;

import com.zoyi.io.socket.okhttp3.Address;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.Route;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.connection.RouteDatabase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public final class RouteSelector {
    private final Address address;
    private final RouteDatabase routeDatabase;
    private Proxy lastProxy;
    private InetSocketAddress lastInetSocketAddress;
    private List<Proxy> proxies = Collections.emptyList();
    private int nextProxyIndex;
    private List<InetSocketAddress> inetSocketAddresses = Collections.emptyList();
    private int nextInetSocketAddressIndex;
    private final List<Route> postponedRoutes = new ArrayList<Route>();

    public RouteSelector(Address address, RouteDatabase routeDatabase) {
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.resetNextProxy(address.url(), address.proxy());
    }

    public final boolean hasNext() {
        return this.hasNextInetSocketAddress() || this.hasNextProxy() || this.hasNextPostponed();
    }

    public final Route next() throws IOException {
        Route route;
        while (true) {
            if (!this.hasNextInetSocketAddress()) {
                if (!this.hasNextProxy()) {
                    if (!this.hasNextPostponed()) {
                        throw new NoSuchElementException();
                    }
                    return this.nextPostponed();
                }
                this.lastProxy = this.nextProxy();
            }
            this.lastInetSocketAddress = this.nextInetSocketAddress();
            route = new Route(this.address, this.lastProxy, this.lastInetSocketAddress);
            if (!this.routeDatabase.shouldPostpone(route)) break;
            this.postponedRoutes.add(route);
        }
        return route;
    }

    public final void connectFailed(Route route, IOException iOException) {
        if (route.proxy().type() != Proxy.Type.DIRECT && this.address.proxySelector() != null) {
            this.address.proxySelector().connectFailed(this.address.url().uri(), route.proxy().address(), iOException);
        }
        this.routeDatabase.failed(route);
    }

    private void resetNextProxy(HttpUrl object, Proxy proxy) {
        List<Proxy> list;
        RouteSelector routeSelector;
        if (proxy != null) {
            routeSelector = this;
            list = Collections.singletonList(proxy);
        } else {
            object = this.address.proxySelector().select(((HttpUrl)object).uri());
            routeSelector = this;
            list = object != null && !object.isEmpty() ? Util.immutableList(object) : Util.immutableList(Proxy.NO_PROXY);
        }
        routeSelector.proxies = list;
        this.nextProxyIndex = 0;
    }

    private boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    private Proxy nextProxy() throws IOException {
        if (!this.hasNextProxy()) {
            throw new SocketException("No route to " + this.address.url().host() + "; exhausted proxy configurations: " + this.proxies);
        }
        Proxy proxy = this.proxies.get(this.nextProxyIndex++);
        this.resetNextInetSocketAddress(proxy);
        return proxy;
    }

    private void resetNextInetSocketAddress(Proxy proxy) throws IOException {
        int n2;
        Object object;
        this.inetSocketAddresses = new ArrayList<InetSocketAddress>();
        if (proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.SOCKS) {
            object = this.address.url().host();
            n2 = this.address.url().port();
        } else {
            object = proxy.address();
            if (!(object instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Proxy.address() is not an InetSocketAddress: " + object.getClass());
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            object = RouteSelector.getHostString(inetSocketAddress);
            n2 = inetSocketAddress.getPort();
        }
        if (n2 <= 0 || n2 > 65535) {
            throw new SocketException("No route to " + (String)object + ":" + n2 + "; port is out of range");
        }
        if (proxy.type() == Proxy.Type.SOCKS) {
            this.inetSocketAddresses.add(InetSocketAddress.createUnresolved((String)object, n2));
        } else {
            object = this.address.dns().lookup((String)object);
            int n3 = object.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                InetAddress inetAddress = object.get(i2);
                this.inetSocketAddresses.add(new InetSocketAddress(inetAddress, n2));
            }
        }
        this.nextInetSocketAddressIndex = 0;
    }

    static String getHostString(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return inetSocketAddress.getHostName();
        }
        return inetAddress.getHostAddress();
    }

    private boolean hasNextInetSocketAddress() {
        return this.nextInetSocketAddressIndex < this.inetSocketAddresses.size();
    }

    private InetSocketAddress nextInetSocketAddress() throws IOException {
        if (!this.hasNextInetSocketAddress()) {
            throw new SocketException("No route to " + this.address.url().host() + "; exhausted inet socket addresses: " + this.inetSocketAddresses);
        }
        return this.inetSocketAddresses.get(this.nextInetSocketAddressIndex++);
    }

    private boolean hasNextPostponed() {
        return !this.postponedRoutes.isEmpty();
    }

    private Route nextPostponed() {
        return this.postponedRoutes.remove(0);
    }
}

